/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.test.parents;

import org.junit.Before;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.http.HeaderNames;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Status;
import org.wisdom.maven.utils.ChameleonInstanceHolder;
import org.wisdom.test.WisdomBlackBoxRunner;
import org.wisdom.test.http.GetRequest;
import org.wisdom.test.http.HttpRequestWithBody;
import org.wisdom.test.internals.ChameleonExecutor;

@RunWith(value=WisdomBlackBoxRunner.class)
public class WisdomBlackBoxTest
implements HeaderNames,
Status {
    private static final Logger LOGGER = LoggerFactory.getLogger(WisdomBlackBoxTest.class);
    private String hostname;
    private int httpPort;
    private int httpsPort;

    public static void installTestBundle() throws BundleException {
        BundleContext context = ChameleonInstanceHolder.get().context();
        Bundle probe = null;
        for (Bundle bundle : context.getBundles()) {
            if (!bundle.getSymbolicName().equalsIgnoreCase("wisdom-probe-bundle")) continue;
            probe = bundle;
        }
        if (probe != null) {
            LOGGER.info("Probe / Test bundle already deployed");
        } else {
            probe = ChameleonExecutor.deployProbe();
            LOGGER.info("Probe / Test bundle deployed ({})", (Object)probe.getBundleId());
            ChameleonInstanceHolder.get().waitForStability();
        }
    }

    public static void removeTestBundle() throws BundleException {
        BundleContext context = ChameleonInstanceHolder.get().context();
        Bundle probe = null;
        for (Bundle bundle : context.getBundles()) {
            if (!bundle.getSymbolicName().equalsIgnoreCase("wisdom-probe-bundle")) continue;
            probe = bundle;
        }
        if (probe != null) {
            probe.uninstall();
            LOGGER.info("Probe / Test bundle uninstall ({})", (Object)probe.getBundleId());
            ChameleonInstanceHolder.get().waitForStability();
        }
    }

    @Before
    public void retrieveServerMetadata() throws Exception {
        if (this.hostname != null) {
            return;
        }
        this.hostname = ChameleonInstanceHolder.getHostName();
        this.httpPort = ChameleonInstanceHolder.getHttpPort();
        this.httpsPort = ChameleonInstanceHolder.getHttpsPort();
    }

    public String getHttpURl(String path) {
        String localUrl = path;
        if (localUrl.startsWith("http")) {
            return localUrl;
        }
        if (!localUrl.startsWith("/")) {
            localUrl = '/' + localUrl;
        }
        return "http://" + this.hostname + ":" + this.httpPort + localUrl;
    }

    public String getHttpsURl(String path) {
        String localUrl = path;
        if (localUrl.startsWith("https")) {
            return localUrl;
        }
        if (!localUrl.startsWith("/")) {
            localUrl = '/' + localUrl;
        }
        return "https://" + this.hostname + ":" + this.httpsPort + localUrl;
    }

    public GetRequest get(String url) {
        return new GetRequest(HttpMethod.GET, this.getHttpURl(url));
    }

    public HttpRequestWithBody post(String url) {
        return new HttpRequestWithBody(HttpMethod.POST, this.getHttpURl(url));
    }

    public HttpRequestWithBody delete(String url) {
        return new HttpRequestWithBody(HttpMethod.DELETE, this.getHttpURl(url));
    }

    public HttpRequestWithBody put(String url) {
        return new HttpRequestWithBody(HttpMethod.PUT, this.getHttpURl(url));
    }
}

