/*
 * Copyright (c) 2016 WisePersist.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wisepersist.apuava.gwt.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * Custom LI widget.
 *
 * @author delight.wjk@gmail.com
 */
public class LiWidget extends SimplePanel { //NOPMD

  /**
   * Constructs a new {@link LiWidget} instance.
   */
  public LiWidget() {
    super((Element) Document.get().createLIElement().cast());
  }

  /**
   * Constructs a new {@link LiWidget} instance with an inner text specified.
   *
   * @param innerText The inner text specified.
   */
  public LiWidget(final String innerText) {
    this();
    getElement().setInnerText(innerText);
  }

  /**
   * Constructs a new {@link LiWidget} instance with a widget specified.
   *
   * @param widget The widget specified.
   */
  public LiWidget(final Widget widget) {
    this();
    this.add(widget);
  }
}
