/*
 * Copyright (c) 2016 WisePersist.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wisepersist.apuava.gwt.client.dom;

import com.google.gwt.dom.client.Element;
import com.google.inject.ImplementedBy;

/**
 * Utility class for building {@link NativeDomImpl} instances.
 *
 * @author delight.wjk@gmail.com
 */
@ImplementedBy(NativeDomWrapperImpl.class)
public interface NativeDomWrapper {

  /**
   * Wraps the element as a {@link NativeDom} instance.
   *
   * @param element The element specified.
   * @return The {@link NativeDom} instance wrapped.
   */
  NativeDom wrap(Element element);
}
