/*
 * Copyright (c) 2016 WisePersist.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wisepersist.apuava.gwt.client.ui;

import com.google.inject.ImplementedBy;

/**
 * This interface defines methods of a notifier.
 *
 * @author jake.wang@practiceinsight.io
 */
@ImplementedBy(NotifierImpl.class)
public interface Notifier {

  /**
   * Shows information message to users. This will be automatically closed after a few seconds.
   * It will also be closed if users click the notification.
   *
   * @param htmlMessage The HTML message specified.
   */
  void info(String htmlMessage);

  /**
   * Shows success message to users. This will be automatically closed after a few seconds.
   * It will also be closed if users click the notification.
   *
   * @param htmlMessage The HTML message specified.
   */
  void success(String htmlMessage);

  /**
   * Shows progress message to users. This cannot be closed by users and will be closed
   * automatically once the job is done.
   *
   * @param htmlMessage The HTML message specified.
   */
  void progress(String htmlMessage);

  /**
   * Shows warning message to users. This will not be closed until users click it.
   *
   * @param htmlMessage The HTML message specified.
   */
  void warning(String htmlMessage);

  /**
   * Shows error message to users. This will not be closed until users click it.
   *
   * @param htmlMessage The HTML message specified.
   */
  void error(String htmlMessage);

  /**
   * Closes the notification popup.
   */
  void close();
}
