/*
 * Copyright (c) 2017 WisePersist.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wisepersist.apuava.gwt.client.ui;

import com.google.common.base.Strings;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HasOneWidget;
import com.google.gwt.user.client.ui.HasVisibility;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * This class wraps a {@link SimplePanel}, which will be replaced with child element when setting
 * a child widget in it. This is useful when we don't want to have additional DIV element.  The
 * DOM will be cleaner, because there won't be redundant DIV element.
 *
 * @author delight.wjk@gmail.com
 */
public class SwapPanel implements IsWidget, HasOneWidget, HasVisibility {

  private IsWidget widget;
  private String style;

  /**
   * Constructor for creating {@link SwapPanel}.
   */
  public SwapPanel() {
    widget = new SimplePanel(); // NOPMD
  }

  @Override
  public final Widget asWidget() {
    return widget.asWidget();
  }

  @Override
  public final Widget getWidget() {
    return widget.asWidget();
  }

  @Override
  public final void setWidget(final Widget widgetToAttach) {
    final Widget parentWidget = widget.asWidget().getParent();
    if (!(parentWidget instanceof HTMLPanel)) {
      throw new IllegalStateException(
          "The parent of " + getClass().getSimpleName() + " must be of type HTMLPanel.");
    }
    final HTMLPanel parentPanel = (HTMLPanel) parentWidget;
    parentPanel.addAndReplaceElement(widgetToAttach, (Element) widget.asWidget().getElement());
    widget = widgetToAttach;
    if (!Strings.isNullOrEmpty(style)) {
      widget.asWidget().addStyleName(style);
    }
  }

  @Override
  public final void setWidget(final IsWidget widget) {
    setWidget(widget.asWidget());
  }

  @Override
  public final boolean isVisible() {
    return asWidget().isVisible();
  }

  @Override
  public final void setVisible(final boolean visible) {
    asWidget().setVisible(visible);
  }

  public final void setAddStyleName(final String styleName) {
    this.style = styleName;
  }
}
