/*
 * Copyright (c) 2016 WisePersist.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wisepersist.apuava.gwt.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * Custom UList widget.
 *
 * @author delight.wjk@gmail.com
 */
public class UListWidget extends ComplexPanel {

  /**
   * Constructs a new {@link UListWidget} instance.
   */
  public UListWidget() {
    super();
    setElement(Document.get().createULElement());
  }

  /**
   * Sets element id.
   *
   * @param id The element id specified.
   */
  public final void setId(final String id) {
    // Set an attribute common to all tags
    getElement().setId(id);
  }

  /**
   * Sets dir property of this element.
   *
   * @param dir The dir property specified.
   */
  public final void setDir(final String dir) {
    // Set an attribute specific to this tag
    ((UListElement) getElement().cast()).setDir(dir);
  }

  /**
   * Adds a widget to this {@link UListWidget} instance.
   *
   * @param widget The widget to be added.
   */
  public final void add(final Widget widget) {
    // ComplexPanel requires the two-arg add() method
    super.add(widget, getElement());
  }
}
