/*
 * Copyright (c) 2016 WisePersist.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wisepersist.apuava.gwt.client.dom;

import com.google.gwt.dom.client.Element;
import com.google.inject.ImplementedBy;

/**
 * This interface represents a native DOM which allows us to add different event listeners.
 *
 * @author delight.wjk@gmail.com
 */
@ImplementedBy(NativeDomImpl.class)
public interface NativeDom {

  /**
   * Wraps an element into a {@link NativeDom} instance.
   *
   * @param element The element specified.
   * @return The {@link NativeDom} instance created.
   */
  NativeDom wrap(Element element);

  /**
   * Adds a {@link NativeClickHandler} instance.
   *
   * @param clickHandler The {@link NativeClickHandler} instance specified.
   * @return The current {@link NativeDom} instance.
   */
  NativeDom addClickHandler(NativeClickHandler clickHandler);

  /**
   * Adds a {@link NativeKeyUpHandler} instance.
   *
   * @param keyUpHandler The {@link NativeKeyUpHandler} instance specified.
   * @return The current {@link NativeDom} instance.
   */
  NativeDom addKeyUpHandler(NativeKeyUpHandler keyUpHandler);

  /**
   * Adds a {@link NativeKeyDownHandler} instance.
   *
   * @param keyDownHandler The {@link NativeKeyDownHandler} instance specified.
   * @return The current {@link NativeDom} instance.
   */
  NativeDom addKeyDownHandler(NativeKeyDownHandler keyDownHandler);

  /**
   * Adds a {@link NativeFocusHandler} instance.
   *
   * @param focusHandler The {@link NativeFocusHandler} instance specified.
   * @return The current {@link NativeDom} instance.
   */
  NativeDom addFocusHandler(NativeFocusHandler focusHandler);

  /**
   * Adds a {@link NativeMouseOutHandler} instance.
   *
   * @param mouseOutHandler The {@link NativeMouseOutHandler} instance specified.
   * @return The current {@link NativeDom} instance.
   */
  NativeDom addMouseOutHandler(NativeMouseOutHandler mouseOutHandler);

  /**
   * Adds a {@link NativeMouseOverHandler} instance.
   *
   * @param mouseOverHandler The {@link NativeMouseOverHandler} instance specified.
   * @return The current {@link NativeDom} instance.
   */
  NativeDom addMouseOverHandler(NativeMouseOverHandler mouseOverHandler);

  /**
   * Adds a {@link NativeDblClickHandler} instance.
   *
   * @param dblClickHandler The {@link NativeDblClickHandler} instance specified.
   * @return The current {@link NativeDom} instance.
   */
  NativeDom addDblClickHandler(NativeDblClickHandler dblClickHandler);

  /**
   * Adds a {@link NativeChangeHandler} instance.
   *
   * @param changeHandler The {@link NativeChangeHandler}
   * @return Updated {@link NativeDom} object.
   */
  NativeDom addChangeHandler(NativeChangeHandler changeHandler);
}
