/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.apuava.resource;

import java.io.Closeable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisepersist.apuava.resource.ResourceHandler;
import org.wisepersist.apuava.resource.VoidResourceHandler;

public class ResourceManager {
    private static final Logger log = LoggerFactory.getLogger(ResourceManager.class);
    private Closeable resource;

    public ResourceManager() {
    }

    private ResourceManager(Closeable theResource) {
        this.resource = theResource;
    }

    public final ResourceManager with(Closeable theResource) {
        return new ResourceManager(theResource);
    }

    public final <T> T run(ResourceHandler<T> handler) throws IOException {
        try {
            T t = handler.handle(this.resource);
            return t;
        }
        finally {
            this.closeResource();
        }
    }

    public final void run(VoidResourceHandler handler) throws IOException {
        try {
            handler.handle(this.resource);
        }
        finally {
            this.closeResource();
        }
    }

    private void closeResource() {
        if (this.resource != null) {
            try {
                this.resource.close();
            }
            catch (IOException ex) {
                log.error(ex.getMessage());
            }
        }
    }
}

