/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.apuava.cli;

import com.google.inject.Singleton;
import org.apache.commons.lang3.SystemUtils;

@Singleton
public class Console {
    private int currLineLength;

    public final Console log(String message) {
        this.clearCurrLine();
        System.out.print(message);
        System.out.flush();
        this.currLineLength = message.length();
        return this;
    }

    public final Console log(String messageFormat, Object ... args) {
        String message = String.format(messageFormat, args);
        return this.log(message);
    }

    private void clearCurrLine() {
        if (SystemUtils.IS_OS_WINDOWS) {
            System.out.print("\r");
            for (int i = 0; i < this.currLineLength; ++i) {
                System.out.print(" ");
            }
        } else {
            System.out.print("\u001b[2K");
        }
        System.out.print("\r");
    }

    public final Console newLine() {
        System.out.println();
        this.currLineLength = 0;
        return this;
    }
}

