/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.apuava.urlfetch;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.wisepersist.apuava.resource.ResourceHandler;
import org.wisepersist.apuava.resource.ResourceManager;
import org.wisepersist.apuava.resource.VoidResourceHandler;
import org.wisepersist.apuava.urlfetch.RequestMethod;
import org.wisepersist.apuava.urlfetch.UrlResponse;

public class UrlFetcher {
    private static final int READ_TIMEOUT = 10000;
    private static final int CONNECT_TIMEOUT = 15000;
    private String url;
    private int readTimeout = 10000;
    private int connectTimeout = 15000;
    private RequestMethod requestMethod = RequestMethod.GET;
    private List<AbstractMap.SimpleEntry<String, String>> headers = Lists.newArrayList();
    private List<AbstractMap.SimpleEntry<String, String>> params = Lists.newArrayList();
    private ResourceManager resourceManager = new ResourceManager();

    public final UrlFetcher setUrl(String theUrl) {
        this.url = theUrl;
        return this;
    }

    public final UrlFetcher setReadTimeout(int theReadTimeout) {
        this.readTimeout = theReadTimeout;
        return this;
    }

    public final UrlFetcher setConnectTimeout(int theConnectTimeout) {
        this.connectTimeout = theConnectTimeout;
        return this;
    }

    public final UrlFetcher setRequestMethod(RequestMethod theRequestMethod) {
        this.requestMethod = theRequestMethod;
        return this;
    }

    public final UrlFetcher addHeader(String name, String value) {
        this.headers.add(new AbstractMap.SimpleEntry<String, String>(name, value));
        return this;
    }

    public final UrlFetcher addParam(String name, String value) {
        this.params.add(new AbstractMap.SimpleEntry<String, String>(name, value));
        return this;
    }

    public final UrlResponse execute() throws IOException {
        Preconditions.checkNotNull((Object)this.url);
        HttpURLConnection conn = this.prepareConnection();
        conn.connect();
        return this.readResponse(conn);
    }

    private HttpURLConnection prepareConnection() throws IOException {
        String queryStr = this.getQuery(this.params);
        if (this.requestMethod == RequestMethod.GET) {
            this.url = this.url + "?" + queryStr;
        }
        URL urlObj = new URL(this.url);
        HttpURLConnection conn = (HttpURLConnection)urlObj.openConnection();
        conn.setReadTimeout(this.readTimeout);
        conn.setConnectTimeout(this.connectTimeout);
        conn.setRequestMethod(this.requestMethod.name());
        conn.setDoInput(true);
        conn.setDoOutput(true);
        this.setHeaders(conn);
        if (this.requestMethod == RequestMethod.POST) {
            this.writeToConnection(conn, queryStr);
        }
        return conn;
    }

    private void setHeaders(HttpURLConnection conn) {
        for (AbstractMap.SimpleEntry<String, String> header : this.headers) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
    }

    private UrlResponse readResponse(HttpURLConnection conn) throws IOException {
        int responseCode = conn.getResponseCode();
        String content = this.readContent(conn);
        return new UrlResponse(responseCode, content);
    }

    public final String getQueryString() throws UnsupportedEncodingException {
        return this.getQuery(this.params);
    }

    private String readContent(HttpURLConnection conn) throws IOException {
        final InputStream inputStream = conn.getInputStream();
        return this.resourceManager.with(inputStream).run(new ResourceHandler<String>(){

            @Override
            public String handle(Closeable closeable) throws IOException {
                return IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
            }
        });
    }

    private void writeToConnection(HttpURLConnection conn, final String bodyData) throws IOException {
        final OutputStream outputStream = conn.getOutputStream();
        this.resourceManager.with(outputStream).run(new VoidResourceHandler(){

            @Override
            public void handle(Closeable closeable) throws IOException {
                final BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
                UrlFetcher.this.resourceManager.with(writer).run(new VoidResourceHandler(){

                    @Override
                    public void handle(Closeable closeable) throws IOException {
                        writer.write(bodyData);
                        writer.flush();
                    }
                });
            }
        });
    }

    private String getQuery(List<AbstractMap.SimpleEntry<String, String>> theParams) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (AbstractMap.SimpleEntry<String, String> pair : theParams) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(pair.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(pair.getValue(), "UTF-8"));
        }
        return result.toString();
    }
}

