/*
 * Copyright 2014-2016 Wise Persist Pty Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wisepersist.gwt.ace.client;

/**
 * This enumeration represents the selection/marker types.
 */
public enum AceMarkerType {

  /**
   * Highlights the whole line.
   */
  FULL_LINE("fullLine"),

  /**
   * Highlights the whole screen line.
   */
  SCREEN_LINE("screenLine"),

  /**
   * Highlights only the range.
   */
  TEXT("text");

  private final String name;

  private AceMarkerType(final String name) {
    this.name = name;
  }

  /**
   * @return the marker type name (e.g., "error")
   */
  public String getName() {
    return name;
  }
}
