/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.gradle.plugins.gwt;

import java.io.File;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.wisepersist.gradle.plugins.gwt.GwtBasePlugin;
import org.wisepersist.gradle.plugins.gwt.GwtCheck;
import org.wisepersist.gradle.plugins.gwt.GwtCompile;
import org.wisepersist.gradle.plugins.gwt.GwtDraftCompile;

public class GwtCompilerPlugin
implements Plugin<Project> {
    public static final String OUT_DIR = "out";
    public static final String DRAFT_OUT_DIR = "draftOut";
    public static final String TASK_COMPILE_GWT = "compileGwt";
    public static final String TASK_DRAFT_COMPILE_GWT = "draftCompileGwt";
    public static final String TASK_CHECK = "checkGwt";

    public void apply(Project project) {
        project.getPlugins().apply(GwtBasePlugin.class);
        File gwtBuildDir = new File(project.getBuildDir(), "gwt");
        GwtCompile compileTask = (GwtCompile)project.getTasks().create(TASK_COMPILE_GWT, GwtCompile.class);
        compileTask.setWar(new File(gwtBuildDir, OUT_DIR));
        compileTask.setDescription("Runs the GWT compiler to translate Java sources to JavaScript for production ready output");
        compileTask.dependsOn(new Object[]{"compileJava", "processResources"});
        GwtDraftCompile draftCompileTask = (GwtDraftCompile)project.getTasks().create(TASK_DRAFT_COMPILE_GWT, GwtDraftCompile.class);
        draftCompileTask.setWar(new File(gwtBuildDir, DRAFT_OUT_DIR));
        draftCompileTask.setDescription("Runs the GWT compiler to produce draft quality output used for development");
        draftCompileTask.dependsOn(new Object[]{"compileJava", "processResources"});
        GwtCheck gwtCheck = (GwtCheck)project.getTasks().create(TASK_CHECK, GwtCheck.class);
        gwtCheck.setDescription("Runs the GWT compiler to validate the relevant sources");
        gwtCheck.dependsOn(new Object[]{"compileJava", "processResources"});
        gwtCheck.setGroup("verification");
    }
}

