/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.gradle.plugins.gwt;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;
import org.wisepersist.gradle.plugins.gwt.AbstractGwtActionTask$1$$Lambda$1;
import org.wisepersist.gradle.plugins.gwt.AbstractGwtActionTask$1$$Lambda$2;
import org.wisepersist.gradle.plugins.gwt.GwtJsInteropExportsOptions;
import org.wisepersist.gradle.plugins.gwt.JsInteropMode;
import org.wisepersist.gradle.plugins.gwt.LogLevel;
import org.wisepersist.gradle.plugins.gwt.MethodNameDisplayMode;

public abstract class AbstractGwtActionTask
extends DefaultTask {
    private List<String> modules;
    private FileCollection src;
    private FileCollection classpath;
    private String minHeapSize;
    private String maxHeapSize;
    private final String main;
    private List<Object> args = new ArrayList<Object>();
    private List<Object> jvmArgs = new ArrayList<Object>();
    private boolean debug;
    private LogLevel logLevel;
    private String sourceLevel;
    private Boolean incremental;
    private JsInteropMode jsInteropMode;
    private GwtJsInteropExportsOptions jsInteropExports;
    private MethodNameDisplayMode methodNameDisplayMode;

    public AbstractGwtActionTask(String main) {
        this.main = main;
    }

    @TaskAction
    public void exec() {
        ExecResult execResult = this.getProject().javaexec((Action)new Action<JavaExecSpec>(){

            public void execute(JavaExecSpec javaExecSpec) {
                if (AbstractGwtActionTask.this.getSrc() == null) {
                    throw new InvalidUserDataException("No Source is set");
                }
                if (AbstractGwtActionTask.this.getClasspath() == null) {
                    throw new InvalidUserDataException("Classpath is not set");
                }
                if (AbstractGwtActionTask.this.getModules() == null || AbstractGwtActionTask.this.getModules().isEmpty()) {
                    throw new InvalidUserDataException("No module[s] given");
                }
                if (AbstractGwtActionTask.this.getJsInteropExports().shouldGenerate() && AbstractGwtActionTask.this.getJsInteropExports().getIncludePatterns().isEmpty() && !AbstractGwtActionTask.this.getJsInteropExports().getExcludePatterns().isEmpty()) {
                    throw new InvalidUserDataException("No include pattern(s) for JsInterop exports given");
                }
                javaExecSpec.setMain(AbstractGwtActionTask.this.main);
                javaExecSpec.setDebug(AbstractGwtActionTask.this.isDebug());
                javaExecSpec.setMinHeapSize(AbstractGwtActionTask.this.getMinHeapSize());
                javaExecSpec.setMaxHeapSize(AbstractGwtActionTask.this.getMaxHeapSize());
                FileCollection classpath = AbstractGwtActionTask.this.getClasspath();
                if (AbstractGwtActionTask.this.prependSrcToClasspath()) {
                    classpath = AbstractGwtActionTask.this.getSrc().plus(classpath);
                }
                if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                    javaExecSpec.environment("CLASSPATH", (Object)classpath.getAsPath());
                } else {
                    javaExecSpec.setClasspath(classpath);
                }
                AbstractGwtActionTask.this.argIfSet("-XjsInteropMode", (Object)AbstractGwtActionTask.this.getJsInteropMode());
                AbstractGwtActionTask.this.argOnOff(AbstractGwtActionTask.this.getJsInteropExports().shouldGenerate(), "-generateJsInteropExports", "-nogenerateJsInteropExports");
                AbstractGwtActionTask.this.getJsInteropExports().getIncludePatterns().forEach(AbstractGwtActionTask$1$$Lambda$1.lambdaFactory$(this));
                AbstractGwtActionTask.this.getJsInteropExports().getExcludePatterns().forEach(AbstractGwtActionTask$1$$Lambda$2.lambdaFactory$(this));
                AbstractGwtActionTask.this.argIfSet("-XmethodNameDisplayMode", (Object)AbstractGwtActionTask.this.getMethodNameDisplayMode());
                AbstractGwtActionTask.this.argOnOff(AbstractGwtActionTask.this.getIncremental(), "-incremental", "-noincremental");
                AbstractGwtActionTask.this.argIfSet("-sourceLevel", AbstractGwtActionTask.this.getSourceLevel());
                AbstractGwtActionTask.this.argIfSet("-logLevel", (Object)AbstractGwtActionTask.this.getLogLevel());
                AbstractGwtActionTask.this.addArgs();
                javaExecSpec.jvmArgs((Iterable)AbstractGwtActionTask.this.jvmArgs);
                javaExecSpec.args((Iterable)AbstractGwtActionTask.this.args);
                javaExecSpec.args(AbstractGwtActionTask.this.getModules());
            }

            static /* synthetic */ void lambda$execute$1(1 this_, String excludePattern) {
                this_.AbstractGwtActionTask.this.argIfSet("-excludeJsInteropExports", excludePattern);
            }

            static /* synthetic */ void lambda$execute$0(1 this_, String includePattern) {
                this_.AbstractGwtActionTask.this.argIfSet("-includeJsInteropExports", includePattern);
            }
        });
        execResult.assertNormalExitValue().rethrowFailure();
    }

    protected boolean prependSrcToClasspath() {
        return true;
    }

    @Input
    public List<String> getModules() {
        return this.modules;
    }

    public void setModules(List<String> modules) {
        this.modules = modules;
    }

    protected void args(Object ... args) {
        this.args.addAll(Arrays.asList(args));
    }

    protected void jvmArgs(Object ... args) {
        this.jvmArgs.addAll(Arrays.asList(args));
    }

    protected void argIfEnabled(Boolean condition, String arg) {
        if (Boolean.TRUE.equals(condition)) {
            this.args(arg);
        }
    }

    protected void argOnOff(Boolean condition, String onArg, String offArg) {
        if (Boolean.TRUE.equals(condition)) {
            this.args(onArg);
        } else if (Boolean.FALSE.equals(condition)) {
            this.args(offArg);
        }
    }

    protected void dirArgIfSet(String arg, File dir) {
        if (dir != null) {
            dir.mkdirs();
            this.args(arg, dir);
        }
    }

    protected void argIfSet(String arg, Object value) {
        if (value != null) {
            this.args(arg, value);
        }
    }

    protected abstract void addArgs();

    protected boolean isDevTask() {
        return true;
    }

    @InputFiles
    public FileCollection getSrc() {
        return this.src;
    }

    public void setSrc(FileCollection src) {
        this.src = src;
    }

    @Input
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    public String getMinHeapSize() {
        return this.minHeapSize;
    }

    public void setMinHeapSize(String minHeapSize) {
        this.minHeapSize = minHeapSize;
    }

    public String getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public void setMaxHeapSize(String maxHeapSize) {
        this.maxHeapSize = maxHeapSize;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public String getSourceLevel() {
        return this.sourceLevel;
    }

    public void setSourceLevel(String sourceLevel) {
        this.sourceLevel = sourceLevel;
    }

    public Boolean getIncremental() {
        return this.incremental;
    }

    public void setIncremental(Boolean incremental) {
        this.incremental = incremental;
    }

    public JsInteropMode getJsInteropMode() {
        return this.jsInteropMode;
    }

    public void setJsInteropMode(JsInteropMode jsInteropMode) {
        this.jsInteropMode = jsInteropMode;
    }

    public GwtJsInteropExportsOptions getJsInteropExports() {
        return this.jsInteropExports;
    }

    public void setJsInteropExports(GwtJsInteropExportsOptions jsInteropExports) {
        this.jsInteropExports = jsInteropExports;
    }

    public MethodNameDisplayMode getMethodNameDisplayMode() {
        return this.methodNameDisplayMode;
    }

    public void setMethodNameDisplayMode(MethodNameDisplayMode methodNameDisplayMode) {
        this.methodNameDisplayMode = methodNameDisplayMode;
    }
}

