/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.gradle.plugins.gwt;

import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.testing.Test;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.wisepersist.gradle.plugins.gwt.AbstractGwtActionTask;
import org.wisepersist.gradle.plugins.gwt.AbstractGwtCompile;
import org.wisepersist.gradle.plugins.gwt.AbstractGwtTask;
import org.wisepersist.gradle.plugins.gwt.GwtBasePlugin$6$$Lambda$1;
import org.wisepersist.gradle.plugins.gwt.GwtBasePlugin$6$$Lambda$2;
import org.wisepersist.gradle.plugins.gwt.GwtDev;
import org.wisepersist.gradle.plugins.gwt.GwtEclipsePlugin;
import org.wisepersist.gradle.plugins.gwt.GwtIdeaPlugin;
import org.wisepersist.gradle.plugins.gwt.GwtPluginExtension;
import org.wisepersist.gradle.plugins.gwt.GwtSuperDev;
import org.wisepersist.gradle.plugins.gwt.GwtTestExtension;
import org.wisepersist.gradle.plugins.gwt.GwtWarPlugin;
import org.wisepersist.gradle.plugins.gwt.JsInteropMode;
import org.wisepersist.gradle.plugins.gwt.LogLevel;
import org.wisepersist.gradle.plugins.gwt.internal.GwtVersion;

public class GwtBasePlugin
implements Plugin<Project> {
    public static final String GWT_TASK_GROUP = "GWT";
    public static final String GWT_CONFIGURATION = "gwt";
    public static final String GWT_SDK_CONFIGURATION = "gwtSdk";
    public static final String EXTENSION_NAME = "gwt";
    public static final String BUILD_DIR = "gwt";
    public static final String EXTRA_DIR = "extra";
    public static final String WORK_DIR = "work";
    public static final String GEN_DIR = "gen";
    public static final String CACHE_DIR = "cache";
    public static final String LOG_DIR = "log";
    public static final String DEV_WAR = "war";
    public static final String TASK_GWT_SUPER_DEV = "gwtSuperDev";
    public static final String GWT_GROUP = "com.google.gwt";
    public static final String GWT_DEV = "gwt-dev";
    public static final String GWT_USER = "gwt-user";
    public static final String GWT_CODESERVER = "gwt-codeserver";
    public static final String GWT_ELEMENTAL = "gwt-elemental";
    public static final String GWT_SERVLET = "gwt-servlet";
    private static final Logger logger = Logging.getLogger(GwtBasePlugin.class);
    private Project project;
    private GwtPluginExtension extension;
    private Configuration gwtConfiguration;
    private Configuration gwtSdkConfiguration;
    private ConfigurableFileCollection allGwtConfigurations;

    public void apply(final Project project) {
        this.project = project;
        project.getPlugins().apply(JavaPlugin.class);
        File gwtBuildDir = new File(project.getBuildDir(), "gwt");
        this.extension = this.configureGwtExtension(gwtBuildDir);
        this.configureAbstractActionTasks();
        this.configureAbstractTasks();
        this.configureGwtCompile();
        this.configureGwtDev();
        this.configureGwtSuperDev();
        this.gwtConfiguration = ((Configuration)project.getConfigurations().create("gwt")).setDescription("Classpath for GWT client libraries that are not included in the war");
        this.gwtSdkConfiguration = ((Configuration)project.getConfigurations().create(GWT_SDK_CONFIGURATION)).setDescription("Classpath for GWT SDK libraries (gwt-dev, gwt-user)");
        this.allGwtConfigurations = project.files(new Object[]{this.gwtConfiguration, this.gwtSdkConfiguration});
        this.addToMainSourceSetClasspath((FileCollection)this.allGwtConfigurations);
        final SourceSet testSourceSet = this.getTestSourceSet();
        testSourceSet.setCompileClasspath(testSourceSet.getCompileClasspath().plus((FileCollection)this.allGwtConfigurations));
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                int minor;
                FileCollection runtimeClasspath = GwtBasePlugin.this.allGwtConfigurations.plus(testSourceSet.getRuntimeClasspath());
                if (GwtBasePlugin.this.extension.getTest().isHasGwtTests()) {
                    runtimeClasspath = project.files(GwtBasePlugin.this.getMainSourceSet().getAllJava().getSrcDirs().toArray()).plus((FileCollection)project.files(testSourceSet.getAllJava().getSrcDirs().toArray())).plus(runtimeClasspath);
                    GwtBasePlugin.this.configureTestTasks(GwtBasePlugin.this.extension);
                }
                testSourceSet.setRuntimeClasspath(runtimeClasspath);
                GwtVersion parsedGwtVersion = GwtBasePlugin.this.parseGwtVersion();
                int major = parsedGwtVersion == null ? 2 : parsedGwtVersion.getMajor();
                int n = minor = parsedGwtVersion == null ? 5 : parsedGwtVersion.getMinor();
                if ((major == 2 && minor >= 5 || major > 2) && GwtBasePlugin.this.extension.isCodeserver()) {
                    GwtBasePlugin.this.createSuperDevModeTask(project);
                }
                if (parsedGwtVersion != null) {
                    project.getDependencies().add(GwtBasePlugin.GWT_SDK_CONFIGURATION, (Object)GwtBasePlugin.this.gwtDependency(GwtBasePlugin.GWT_DEV, parsedGwtVersion));
                    project.getDependencies().add(GwtBasePlugin.GWT_SDK_CONFIGURATION, (Object)GwtBasePlugin.this.gwtDependency(GwtBasePlugin.GWT_USER, parsedGwtVersion));
                    project.getDependencies().add("runtimeElements", (Object)GwtBasePlugin.this.gwtDependency(GwtBasePlugin.GWT_SERVLET, parsedGwtVersion));
                    if (major == 2 && minor >= 5 || major > 2) {
                        if (GwtBasePlugin.this.extension.isCodeserver()) {
                            project.getDependencies().add("gwt", (Object)GwtBasePlugin.this.gwtDependency(GwtBasePlugin.GWT_CODESERVER, parsedGwtVersion));
                        }
                        if (GwtBasePlugin.this.extension.isElemental()) {
                            project.getDependencies().add("gwt", (Object)GwtBasePlugin.this.gwtDependency(GwtBasePlugin.GWT_ELEMENTAL, parsedGwtVersion));
                        }
                    } else {
                        logger.warn("GWT version is < 2.5 -> additional dependencies are not added.");
                    }
                }
            }
        });
        project.getPlugins().withType(EclipsePlugin.class, (Action)new Action<EclipsePlugin>(){

            public void execute(EclipsePlugin eclipsePlugin) {
                new GwtEclipsePlugin().apply(project, GwtBasePlugin.this);
            }
        });
        project.getPlugins().withType(IdeaPlugin.class, (Action)new Action<IdeaPlugin>(){

            public void execute(IdeaPlugin ideaPlugin) {
                new GwtIdeaPlugin().apply(project, GwtBasePlugin.this);
            }
        });
    }

    private GwtVersion parseGwtVersion() {
        try {
            return GwtVersion.parse(this.extension.getGwtVersion());
        }
        catch (IllegalArgumentException e) {
            logger.warn(e.getMessage());
            return null;
        }
    }

    private String gwtDependency(String artifactId, GwtVersion gwtVersion) {
        return String.format("%s:%s:%s", GWT_GROUP, artifactId, gwtVersion.toString());
    }

    private GwtPluginExtension configureGwtExtension(File buildDir) {
        GwtPluginExtension extension = (GwtPluginExtension)this.project.getExtensions().create("gwt", GwtPluginExtension.class, new Object[0]);
        extension.setDevWar(this.project.file((Object)DEV_WAR));
        extension.setExtraDir(new File(buildDir, EXTRA_DIR));
        extension.setWorkDir(new File(buildDir, WORK_DIR));
        extension.setGenDir(new File(buildDir, GEN_DIR));
        extension.setCacheDir(new File(buildDir, CACHE_DIR));
        extension.getDev().setLogDir(new File(buildDir, LOG_DIR));
        extension.getCompiler().setLocalWorkers(Runtime.getRuntime().availableProcessors());
        extension.setLogLevel(this.getLogLevel());
        extension.getSuperDev().setUseClasspathForSrc(true);
        ConventionMapping conventionMapping = ((IConventionAware)extension).getConventionMapping();
        conventionMapping.map("src", (Callable)new Callable<FileCollection>(){

            @Override
            public FileCollection call() throws Exception {
                SourceSet mainSourceSet = GwtBasePlugin.this.getMainSourceSet();
                return GwtBasePlugin.this.project.files(new Object[]{mainSourceSet.getAllJava().getSrcDirs()}).plus((FileCollection)GwtBasePlugin.this.project.files(new Object[]{mainSourceSet.getOutput().getResourcesDir()}));
            }
        });
        return extension;
    }

    private void createSuperDevModeTask(Project project) {
        GwtSuperDev superDevTask = (GwtSuperDev)project.getTasks().create(TASK_GWT_SUPER_DEV, GwtSuperDev.class);
        superDevTask.dependsOn(new Object[]{"compileJava", "processResources"});
        superDevTask.setDescription("Runs the GWT super dev mode");
    }

    private void configureAbstractTasks() {
        this.project.getTasks().withType(AbstractGwtTask.class, (Action)new Action<AbstractGwtTask>(){

            public void execute(AbstractGwtTask task) {
                ConventionMapping conventionMapping = ((IConventionAware)task).getConventionMapping();
                conventionMapping.map(GwtBasePlugin.EXTRA_DIR, (Callable)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return GwtBasePlugin.this.extension.getExtraDir();
                    }
                });
                conventionMapping.map("workDir", (Callable)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return GwtBasePlugin.this.extension.getWorkDir();
                    }
                });
                conventionMapping.map(GwtBasePlugin.GEN_DIR, (Callable)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return GwtBasePlugin.this.extension.getGenDir();
                    }
                });
                conventionMapping.map("cacheDir", (Callable)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return GwtBasePlugin.this.extension.getCacheDir();
                    }
                });
                conventionMapping.map("logLevel", (Callable)new Callable<LogLevel>(){

                    @Override
                    public LogLevel call() throws Exception {
                        return GwtBasePlugin.this.extension.getLogLevel();
                    }
                });
            }
        });
    }

    private void configureAbstractActionTasks() {
        JavaPluginConvention javaConvention = this.getJavaConvention();
        final SourceSet mainSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("main");
        this.project.getTasks().withType(AbstractGwtActionTask.class, (Action)new Action<AbstractGwtActionTask>(){

            public void execute(final AbstractGwtActionTask task) {
                task.setGroup(GwtBasePlugin.GWT_TASK_GROUP);
                ConventionMapping conventionMapping = ((IConventionAware)task).getConventionMapping();
                conventionMapping.map("gwtVersion", (Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return GwtBasePlugin.this.extension.getGwtVersion();
                    }
                });
                conventionMapping.map("modules", (Callable)new Callable<List<String>>(){

                    @Override
                    public List<String> call() throws Exception {
                        List<String> devModules = GwtBasePlugin.this.extension.getDevModules();
                        if (task.isDevTask() && devModules != null && !devModules.isEmpty()) {
                            return devModules;
                        }
                        return GwtBasePlugin.this.extension.getModules();
                    }
                });
                conventionMapping.map("src", (Callable)new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        return GwtBasePlugin.this.extension.getSrc();
                    }
                });
                conventionMapping.map("classpath", (Callable)new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        return mainSourceSet.getCompileClasspath().plus((FileCollection)GwtBasePlugin.this.project.files(new Object[]{mainSourceSet.getOutput().getClassesDirs()}));
                    }
                });
                conventionMapping.map("minHeapSize", (Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return GwtBasePlugin.this.extension.getMinHeapSize();
                    }
                });
                conventionMapping.map("maxHeapSize", (Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return GwtBasePlugin.this.extension.getMaxHeapSize();
                    }
                });
                conventionMapping.map("sourceLevel", (Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return GwtBasePlugin.this.extension.getSourceLevel();
                    }
                });
                conventionMapping.map("incremental", (Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return GwtBasePlugin.this.extension.getIncremental();
                    }
                });
                conventionMapping.map("jsInteropMode", (Callable)new Callable<JsInteropMode>(){

                    @Override
                    public JsInteropMode call() throws Exception {
                        return GwtBasePlugin.this.extension.getJsInteropMode();
                    }
                });
                GwtPluginExtension gwtPluginExtension = GwtBasePlugin.this.extension;
                gwtPluginExtension.getClass();
                conventionMapping.map("jsInteropExports", GwtBasePlugin$6$$Lambda$1.lambdaFactory$(gwtPluginExtension));
                GwtPluginExtension gwtPluginExtension2 = GwtBasePlugin.this.extension;
                gwtPluginExtension2.getClass();
                conventionMapping.map("methodNameDisplayMode", GwtBasePlugin$6$$Lambda$2.lambdaFactory$(gwtPluginExtension2));
            }
        });
    }

    private void configureGwtCompile() {
        this.project.getTasks().withType(AbstractGwtCompile.class, (Action)new Action<AbstractGwtCompile>(){

            public void execute(AbstractGwtCompile task) {
                task.configure(GwtBasePlugin.this.extension.getCompiler());
            }
        });
    }

    private void configureGwtDev() {
        final boolean debug = "true".equals(System.getProperty("gwtDev.debug"));
        this.project.getTasks().withType(GwtDev.class, (Action)new Action<GwtDev>(){

            public void execute(GwtDev task) {
                task.configure(GwtBasePlugin.this.extension);
                task.setDebug(debug);
            }
        });
    }

    private void configureGwtSuperDev() {
        this.project.getTasks().withType(GwtSuperDev.class, (Action)new Action<GwtSuperDev>(){

            public void execute(GwtSuperDev task) {
                task.configure(GwtBasePlugin.this.extension.getSuperDev());
                ConventionMapping conventionMapping = ((IConventionAware)task).getConventionMapping();
                conventionMapping.map("workDir", (Callable)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return GwtBasePlugin.this.extension.getWorkDir();
                    }
                });
            }
        });
    }

    private void configureTestTasks(final GwtPluginExtension gwtPluginExtension) {
        this.project.getTasks().withType(Test.class, (Action)new Action<Test>(){

            public void execute(final Test testTask) {
                testTask.getTestLogging().setShowStandardStreams(true);
                final GwtTestExtension testExtension = (GwtTestExtension)testTask.getExtensions().create("gwt", GwtTestExtension.class, new Object[0]);
                testExtension.configure(gwtPluginExtension, (IConventionAware)testExtension);
                GwtBasePlugin.this.project.afterEvaluate((Action)new Action<Project>(){

                    public void execute(Project t) {
                        String gwtArgs = testExtension.getParameterString();
                        testTask.systemProperty("gwt.args", (Object)gwtArgs);
                        logger.info("Using gwt.args for test: " + gwtArgs);
                        if (testExtension.getCacheDir() != null) {
                            testTask.systemProperty("gwt.persistentunitcachedir", (Object)testExtension.getCacheDir());
                            testExtension.getCacheDir().mkdirs();
                            logger.info("Using gwt.persistentunitcachedir for test: {0}", (Object)testExtension.getCacheDir());
                        }
                    }
                });
                GwtBasePlugin.this.project.getPlugins().withType(GwtWarPlugin.class, (Action)new Action<GwtWarPlugin>(){

                    public void execute(GwtWarPlugin t) {
                        testTask.dependsOn(new Object[]{"warTemplate"});
                    }
                });
            }
        });
    }

    private LogLevel getLogLevel() {
        if (logger.isTraceEnabled()) {
            return LogLevel.TRACE;
        }
        if (logger.isDebugEnabled()) {
            return LogLevel.DEBUG;
        }
        if (logger.isInfoEnabled()) {
            return LogLevel.INFO;
        }
        if (logger.isLifecycleEnabled() || logger.isWarnEnabled()) {
            return LogLevel.WARN;
        }
        return LogLevel.ERROR;
    }

    private SourceSet getMainSourceSet() {
        return (SourceSet)this.getJavaConvention().getSourceSets().getByName("main");
    }

    private SourceSet getTestSourceSet() {
        return (SourceSet)this.getJavaConvention().getSourceSets().getByName("test");
    }

    private JavaPluginConvention getJavaConvention() {
        return (JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class);
    }

    private void addToMainSourceSetClasspath(FileCollection fileCollection) {
        SourceSet mainSourceSet = this.getMainSourceSet();
        mainSourceSet.setCompileClasspath(this.getMainSourceSet().getCompileClasspath().plus(fileCollection));
    }

    GwtPluginExtension getExtension() {
        return this.extension;
    }

    Configuration getGwtConfiguration() {
        return this.gwtConfiguration;
    }

    Configuration getGwtSdkConfiguration() {
        return this.gwtSdkConfiguration;
    }

    ConfigurableFileCollection getAllGwtConfigurations() {
        return this.allGwtConfigurations;
    }
}

