/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.gradle.plugins.gwt;

import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.internal.IConventionAware;
import org.wisepersist.gradle.plugins.gwt.GwtPluginExtension;
import org.wisepersist.gradle.plugins.gwt.GwtTestOptions;
import org.wisepersist.gradle.plugins.gwt.GwtTestOptionsBase;
import org.wisepersist.gradle.plugins.gwt.LogLevel;
import org.wisepersist.gradle.plugins.gwt.Style;

public class GwtTestExtension
extends GwtTestOptionsBase {
    private File war;
    private File deploy;
    private File extra;
    private File workDir;
    private File gen;
    private File cacheDir;

    protected String getParameterString() {
        StringBuilder builder = new StringBuilder();
        this.dirArgIfSet(builder, "-war", this.getWar());
        this.dirArgIfSet(builder, "-deploy", this.getDeploy());
        this.dirArgIfSet(builder, "-extra", this.getExtra());
        this.dirArgIfSet(builder, "-workDir", this.getWorkDir());
        this.dirArgIfSet(builder, "-gen", this.getGen());
        this.argIfSet(builder, "-logLevel", (Object)this.getLogLevel());
        this.argIfSet(builder, "-port", Boolean.TRUE.equals(this.getAutoPort()) ? "auto" : this.getPort());
        this.argIfSet(builder, "-whitelist", this.getWhitelist());
        this.argIfSet(builder, "-blacklist", this.getBlacklist());
        this.argIfSet(builder, "-logdir", this.getLogDir());
        this.argIfSet(builder, "-codeServerPort", Boolean.TRUE.equals(this.getAutoCodeServerPort()) ? "auto" : this.getCodeServerPort());
        this.argIfSet(builder, "-style", (Object)this.getStyle());
        this.argIfEnabled(builder, this.getEa(), "-ea");
        this.argIfEnabled(builder, this.getDisableClassMetadata(), "-XdisableClassMetadata");
        this.argIfEnabled(builder, this.getDisableCastChecking(), "-XdisableCastChecking");
        this.argIfEnabled(builder, this.getDraftCompile(), "-draftCompile");
        this.argIfSet(builder, "-localWorkers", this.getLocalWorkers());
        this.argIfEnabled(builder, this.getProd(), "-prod");
        this.argIfSet(builder, "-testMethodTimeout", this.getTestMethodTimeout());
        this.argIfSet(builder, "-testBeginTimeout", this.getTestBeginTimeout());
        this.argIfSet(builder, "-runStyle", this.getRunStyle());
        this.argIfEnabled(builder, this.getNotHeadless(), "-notHeadless");
        this.argIfEnabled(builder, this.getStandardsMode(), "-standardsMode");
        this.argIfEnabled(builder, this.getQuirksMode(), "-quirksMode");
        this.argIfSet(builder, "-Xtries", this.getTries());
        this.argIfSet(builder, "-userAgents", this.getUserAgents());
        return builder.toString();
    }

    private void argIfEnabled(StringBuilder builder, Boolean condition, String arg) {
        if (Boolean.TRUE.equals(condition)) {
            this.arg(builder, arg);
        }
    }

    private void dirArgIfSet(StringBuilder builder, String arg, File dir) {
        if (dir != null) {
            dir.mkdirs();
            this.arg(builder, arg, dir);
        }
    }

    private void argIfSet(StringBuilder builder, String arg, Object value) {
        if (value != null) {
            this.arg(builder, arg, value);
        }
    }

    private void arg(StringBuilder builder, Object ... args) {
        for (Object arg : args) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(arg.toString());
        }
    }

    protected void configure(final GwtPluginExtension extension, IConventionAware conventionAware) {
        final GwtTestOptions testOptions = extension.getTest();
        conventionAware.getConventionMapping().map("war", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return extension.getDevWar();
            }
        });
        conventionAware.getConventionMapping().map("extra", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return extension.getExtraDir();
            }
        });
        conventionAware.getConventionMapping().map("workDir", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return extension.getWorkDir();
            }
        });
        conventionAware.getConventionMapping().map("gen", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return extension.getGenDir();
            }
        });
        conventionAware.getConventionMapping().map("cacheDir", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return extension.getCacheDir();
            }
        });
        conventionAware.getConventionMapping().map("logLevel", (Callable)new Callable<LogLevel>(){

            @Override
            public LogLevel call() throws Exception {
                return extension.getLogLevel();
            }
        });
        conventionAware.getConventionMapping().map("port", (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return testOptions.getPort();
            }
        });
        conventionAware.getConventionMapping().map("autoPort", (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return testOptions.getAutoPort();
            }
        });
        conventionAware.getConventionMapping().map("whitelist", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return testOptions.getWhitelist();
            }
        });
        conventionAware.getConventionMapping().map("blacklist", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return testOptions.getBlacklist();
            }
        });
        conventionAware.getConventionMapping().map("logDir", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return testOptions.getLogDir();
            }
        });
        conventionAware.getConventionMapping().map("codeServerPort", (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return testOptions.getCodeServerPort();
            }
        });
        conventionAware.getConventionMapping().map("autoCodeServerPort", (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return testOptions.getAutoCodeServerPort();
            }
        });
        conventionAware.getConventionMapping().map("style", (Callable)new Callable<Style>(){

            @Override
            public Style call() throws Exception {
                return testOptions.getStyle();
            }
        });
        conventionAware.getConventionMapping().map("ea", (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return testOptions.getEa();
            }
        });
        conventionAware.getConventionMapping().map("disableClassMetadata", (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return testOptions.getDisableClassMetadata();
            }
        });
        conventionAware.getConventionMapping().map("disableCastChecking", (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return testOptions.getDisableCastChecking();
            }
        });
        conventionAware.getConventionMapping().map("draftCompile", (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return testOptions.getDraftCompile();
            }
        });
        conventionAware.getConventionMapping().map("localWorkers", (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return testOptions.getLocalWorkers();
            }
        });
        conventionAware.getConventionMapping().map("prod", (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return testOptions.getProd();
            }
        });
        conventionAware.getConventionMapping().map("testMethodTimeout", (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return testOptions.getTestMethodTimeout();
            }
        });
        conventionAware.getConventionMapping().map("testBeginTimeout", (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return testOptions.getTestBeginTimeout();
            }
        });
        conventionAware.getConventionMapping().map("runStyle", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return testOptions.getRunStyle();
            }
        });
        conventionAware.getConventionMapping().map("notHeadless", (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return testOptions.getNotHeadless();
            }
        });
        conventionAware.getConventionMapping().map("standardsMode", (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return testOptions.getStandardsMode();
            }
        });
        conventionAware.getConventionMapping().map("quirksMode", (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return testOptions.getQuirksMode();
            }
        });
        conventionAware.getConventionMapping().map("tries", (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return testOptions.getTries();
            }
        });
        conventionAware.getConventionMapping().map("userAgents", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return testOptions.getUserAgents();
            }
        });
    }

    public File getWar() {
        return this.war;
    }

    public void setWar(File war) {
        this.war = war;
    }

    public File getDeploy() {
        return this.deploy;
    }

    public void setDeploy(File deploy) {
        this.deploy = deploy;
    }

    public File getExtra() {
        return this.extra;
    }

    public void setExtra(File extra) {
        this.extra = extra;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public File getGen() {
        return this.gen;
    }

    public void setGen(File gen) {
        this.gen = gen;
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public void setCacheDir(File cacheDir) {
        this.cacheDir = cacheDir;
    }
}

