/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.gradle.plugins.gwt;

import java.io.File;
import java.util.List;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.testing.Test;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.wisepersist.gradle.plugins.gwt.AbstractGwtActionTask;
import org.wisepersist.gradle.plugins.gwt.AbstractGwtCompile;
import org.wisepersist.gradle.plugins.gwt.AbstractGwtTask;
import org.wisepersist.gradle.plugins.gwt.GwtDev;
import org.wisepersist.gradle.plugins.gwt.GwtEclipsePlugin;
import org.wisepersist.gradle.plugins.gwt.GwtIdeaPlugin;
import org.wisepersist.gradle.plugins.gwt.GwtPluginExtension;
import org.wisepersist.gradle.plugins.gwt.GwtSuperDev;
import org.wisepersist.gradle.plugins.gwt.GwtTestExtension;
import org.wisepersist.gradle.plugins.gwt.GwtWarPlugin;
import org.wisepersist.gradle.plugins.gwt.LogLevel;
import org.wisepersist.gradle.plugins.gwt.internal.GwtVersion;

public class GwtBasePlugin
implements Plugin<Project> {
    public static final String GWT_TASK_GROUP = "GWT";
    public static final String GWT_CONFIGURATION = "gwt";
    public static final String GWT_SDK_CONFIGURATION = "gwtSdk";
    public static final String EXTENSION_NAME = "gwt";
    public static final String BUILD_DIR = "gwt";
    public static final String WORK_DIR = "work";
    public static final String CACHE_DIR = "cache";
    public static final String LOG_DIR = "log";
    public static final String DEV_WAR = "war";
    public static final String TASK_GWT_SUPER_DEV = "gwtSuperDev";
    public static final String GWT_GROUP = "com.google.gwt";
    public static final String GWT_DEV = "gwt-dev";
    public static final String GWT_USER = "gwt-user";
    public static final String GWT_CODESERVER = "gwt-codeserver";
    public static final String GWT_ELEMENTAL = "gwt-elemental";
    public static final String GWT_SERVLET = "gwt-servlet";
    private static final Logger logger = Logging.getLogger(GwtBasePlugin.class);
    private Project project;
    private GwtPluginExtension extension;
    private Configuration gwtConfiguration;
    private Configuration gwtSdkConfiguration;
    private ConfigurableFileCollection allGwtConfigurations;

    public void apply(Project project) {
        this.project = project;
        project.getPlugins().apply(JavaPlugin.class);
        File gwtBuildDir = new File(project.getBuildDir(), "gwt");
        this.extension = this.configureGwtExtension(gwtBuildDir);
        this.configureAbstractActionTasks();
        this.configureAbstractTasks();
        this.configureGwtCompile();
        this.configureGwtDev();
        this.configureGwtSuperDev();
        this.gwtConfiguration = ((Configuration)project.getConfigurations().create("gwt")).setDescription("Classpath for GWT client libraries that are not included in the war");
        this.gwtSdkConfiguration = ((Configuration)project.getConfigurations().create(GWT_SDK_CONFIGURATION)).setDescription("Classpath for GWT SDK libraries (gwt-dev, gwt-user)");
        this.allGwtConfigurations = project.files(new Object[]{this.gwtConfiguration, this.gwtSdkConfiguration});
        this.addToMainSourceSetClasspath((FileCollection)this.allGwtConfigurations);
        SourceSet testSourceSet = this.getTestSourceSet();
        testSourceSet.setCompileClasspath(testSourceSet.getCompileClasspath().plus((FileCollection)this.allGwtConfigurations));
        project.afterEvaluate(p -> {
            int minor;
            FileCollection runtimeClasspath = this.allGwtConfigurations.plus(testSourceSet.getRuntimeClasspath());
            if (this.extension.getTest().isHasGwtTests()) {
                runtimeClasspath = project.files(this.getMainSourceSet().getAllJava().getSrcDirs().toArray()).plus((FileCollection)project.files(testSourceSet.getAllJava().getSrcDirs().toArray())).plus(runtimeClasspath);
                this.configureTestTasks(this.extension);
            }
            testSourceSet.setRuntimeClasspath(runtimeClasspath);
            GwtVersion parsedGwtVersion = this.parseGwtVersion();
            int major = parsedGwtVersion == null ? 2 : parsedGwtVersion.getMajor();
            int n = minor = parsedGwtVersion == null ? 5 : parsedGwtVersion.getMinor();
            if ((major == 2 && minor >= 5 || major > 2) && this.extension.isCodeserver()) {
                this.createSuperDevModeTask(project);
            }
            if (parsedGwtVersion != null) {
                project.getDependencies().add(GWT_SDK_CONFIGURATION, (Object)this.gwtDependency(GWT_DEV, parsedGwtVersion));
                project.getDependencies().add(GWT_SDK_CONFIGURATION, (Object)this.gwtDependency(GWT_USER, parsedGwtVersion));
                project.getDependencies().add("runtimeOnly", (Object)this.gwtDependency(GWT_SERVLET, parsedGwtVersion));
                if (major == 2 && minor >= 5 || major > 2) {
                    if (this.extension.isCodeserver()) {
                        project.getDependencies().add("gwt", (Object)this.gwtDependency(GWT_CODESERVER, parsedGwtVersion));
                    }
                    if (this.extension.isElemental()) {
                        project.getDependencies().add("gwt", (Object)this.gwtDependency(GWT_ELEMENTAL, parsedGwtVersion));
                    }
                } else {
                    logger.warn("GWT version is < 2.5 -> additional dependencies are not added.");
                }
            }
        });
        project.getPlugins().withType(EclipsePlugin.class, eclipsePlugin -> new GwtEclipsePlugin().apply(project, this));
        project.getPlugins().withType(IdeaPlugin.class, ideaPlugin -> new GwtIdeaPlugin().apply(project, this));
    }

    private GwtVersion parseGwtVersion() {
        try {
            return GwtVersion.parse(this.extension.getGwtVersion());
        }
        catch (IllegalArgumentException e) {
            logger.warn(e.getMessage());
            return null;
        }
    }

    private String gwtDependency(String artifactId, GwtVersion gwtVersion) {
        return String.format("%s:%s:%s", GWT_GROUP, artifactId, gwtVersion.toString());
    }

    private GwtPluginExtension configureGwtExtension(File buildDir) {
        GwtPluginExtension extension = (GwtPluginExtension)this.project.getExtensions().create("gwt", GwtPluginExtension.class, new Object[0]);
        extension.setDevWar(this.project.file((Object)DEV_WAR));
        extension.setWorkDir(new File(buildDir, WORK_DIR));
        extension.setCacheDir(new File(buildDir, CACHE_DIR));
        extension.getDev().setLogDir(new File(buildDir, LOG_DIR));
        extension.getCompiler().setLocalWorkers(Runtime.getRuntime().availableProcessors());
        extension.setLogLevel(this.getLogLevel());
        extension.getSuperDev().setUseClasspathForSrc(true);
        ConventionMapping conventionMapping = ((IConventionAware)extension).getConventionMapping();
        conventionMapping.map("src", () -> {
            SourceSet mainSourceSet = this.getMainSourceSet();
            return this.project.files(new Object[]{mainSourceSet.getAllJava().getSrcDirs()}).plus((FileCollection)this.project.files(new Object[]{mainSourceSet.getOutput().getResourcesDir()}));
        });
        return extension;
    }

    private void createSuperDevModeTask(Project project) {
        GwtSuperDev superDevTask = (GwtSuperDev)project.getTasks().create(TASK_GWT_SUPER_DEV, GwtSuperDev.class);
        superDevTask.dependsOn(new Object[]{"compileJava", "processResources"});
        superDevTask.setDescription("Runs the GWT super dev mode");
    }

    private void configureAbstractTasks() {
        this.project.getTasks().withType(AbstractGwtTask.class, task -> {
            ConventionMapping conventionMapping = ((IConventionAware)task).getConventionMapping();
            conventionMapping.map("extra", () -> this.extension.getExtraDir());
            conventionMapping.map("workDir", () -> this.extension.getWorkDir());
            conventionMapping.map("gen", () -> this.extension.getGenDir());
            conventionMapping.map("cacheDir", () -> this.extension.getCacheDir());
            conventionMapping.map("logLevel", () -> this.extension.getLogLevel());
        });
    }

    private void configureAbstractActionTasks() {
        JavaPluginConvention javaConvention = this.getJavaConvention();
        SourceSet mainSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("main");
        this.project.getTasks().withType(AbstractGwtActionTask.class, task -> {
            task.setGroup(GWT_TASK_GROUP);
            ConventionMapping conventionMapping = ((IConventionAware)task).getConventionMapping();
            conventionMapping.map("gwtVersion", () -> this.extension.getGwtVersion());
            conventionMapping.map("modules", () -> {
                List<String> devModules = this.extension.getDevModules();
                if (task.isDevTask() && devModules != null && !devModules.isEmpty()) {
                    return devModules;
                }
                return this.extension.getModules();
            });
            conventionMapping.map("src", () -> this.extension.getSrc());
            conventionMapping.map("classpath", () -> mainSourceSet.getCompileClasspath().plus((FileCollection)this.project.files(new Object[]{mainSourceSet.getOutput().getClassesDirs()})));
            conventionMapping.map("minHeapSize", () -> this.extension.getMinHeapSize());
            conventionMapping.map("maxHeapSize", () -> this.extension.getMaxHeapSize());
            conventionMapping.map("extraJvmArgs", () -> this.extension.getExtraJvmArgs());
            conventionMapping.map("sourceLevel", () -> this.extension.getSourceLevel());
            conventionMapping.map("incremental", () -> this.extension.getIncremental());
            conventionMapping.map("jsInteropMode", () -> this.extension.getJsInteropMode());
            conventionMapping.map("jsInteropExports", this.extension::getJsInteropExports);
            conventionMapping.map("methodNameDisplayMode", this.extension::getMethodNameDisplayMode);
        });
    }

    private void configureGwtCompile() {
        this.project.getTasks().withType(AbstractGwtCompile.class, task -> task.configure(this.extension.getCompiler()));
    }

    private void configureGwtDev() {
        boolean debug = "true".equals(System.getProperty("gwtDev.debug"));
        this.project.getTasks().withType(GwtDev.class, task -> {
            task.configure(this.extension);
            task.setDebug(debug);
        });
    }

    private void configureGwtSuperDev() {
        this.project.getTasks().withType(GwtSuperDev.class, task -> {
            task.configure(this.extension.getSuperDev());
            ConventionMapping conventionMapping = ((IConventionAware)task).getConventionMapping();
            conventionMapping.map("workDir", () -> this.extension.getWorkDir());
        });
    }

    private void configureTestTasks(GwtPluginExtension gwtPluginExtension) {
        this.project.getTasks().withType(Test.class, testTask -> {
            testTask.getTestLogging().setShowStandardStreams(true);
            GwtTestExtension testExtension = (GwtTestExtension)testTask.getExtensions().create("gwt", GwtTestExtension.class, new Object[0]);
            testExtension.configure(gwtPluginExtension, (IConventionAware)testExtension);
            this.project.afterEvaluate(p -> {
                String gwtArgs = testExtension.getParameterString();
                testTask.systemProperty("gwt.args", (Object)gwtArgs);
                logger.info("Using gwt.args for test: " + gwtArgs);
                if (testExtension.getCacheDir() != null) {
                    testTask.systemProperty("gwt.persistentunitcachedir", (Object)testExtension.getCacheDir());
                    testExtension.getCacheDir().mkdirs();
                    logger.info("Using gwt.persistentunitcachedir for test: {0}", (Object)testExtension.getCacheDir());
                }
            });
            this.project.getPlugins().withType(GwtWarPlugin.class, plugin -> testTask.dependsOn(new Object[]{"warTemplate"}));
        });
    }

    private LogLevel getLogLevel() {
        if (logger.isTraceEnabled()) {
            return LogLevel.TRACE;
        }
        if (logger.isDebugEnabled()) {
            return LogLevel.DEBUG;
        }
        if (logger.isInfoEnabled()) {
            return LogLevel.INFO;
        }
        if (logger.isLifecycleEnabled() || logger.isWarnEnabled()) {
            return LogLevel.WARN;
        }
        return LogLevel.ERROR;
    }

    private SourceSet getMainSourceSet() {
        return (SourceSet)this.getJavaConvention().getSourceSets().getByName("main");
    }

    private SourceSet getTestSourceSet() {
        return (SourceSet)this.getJavaConvention().getSourceSets().getByName("test");
    }

    private JavaPluginConvention getJavaConvention() {
        return (JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class);
    }

    private void addToMainSourceSetClasspath(FileCollection fileCollection) {
        SourceSet mainSourceSet = this.getMainSourceSet();
        mainSourceSet.setCompileClasspath(this.getMainSourceSet().getCompileClasspath().plus(fileCollection));
    }

    GwtPluginExtension getExtension() {
        return this.extension;
    }

    Configuration getGwtConfiguration() {
        return this.gwtConfiguration;
    }

    Configuration getGwtSdkConfiguration() {
        return this.gwtSdkConfiguration;
    }

    ConfigurableFileCollection getAllGwtConfigurations() {
        return this.allGwtConfigurations;
    }
}

