/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.gradle.plugins.gwt;

import java.io.File;
import java.util.Collections;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class ExplodedWar
extends DefaultTask {
    private File destinationDir;
    private File webXml;
    private FileCollection classpath;
    private final CopySpec root = this.getProject().copySpec(spec -> {});
    private final CopySpec webInf = this.root.into((Object)"WEB-INF", spec -> {});

    public ExplodedWar() {
        this.webInf.into((Object)"", spec -> spec.from(new Object[]{() -> this.getWebXml()}).rename(".*", "web.xml"));
        this.webInf.into((Object)"classes", spec -> spec.from(new Object[]{() -> {
            FileCollection classpath = this.getClasspath();
            return classpath == null ? Collections.emptyList() : classpath.filter(file -> file.isDirectory());
        }}));
        this.webInf.into((Object)"lib", spec -> spec.from(new Object[]{() -> {
            FileCollection classpath = this.getClasspath();
            return classpath == null ? Collections.emptyList() : classpath.filter(file -> file.isFile());
        }}));
    }

    @TaskAction
    protected void buildWarTemplate() {
        this.getProject().copy(spec -> {
            spec.into((Object)this.getDestinationDir());
            spec.with(new CopySpec[]{this.root});
        });
    }

    @InputFiles
    @Optional
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    public void classpath(Object ... classpath) {
        FileCollection oldClasspath = this.getClasspath();
        this.classpath = oldClasspath == null ? this.getProject().files(classpath) : this.getProject().files(new Object[]{this.classpath, classpath});
    }

    @InputFile
    @Optional
    public File getWebXml() {
        return this.webXml;
    }

    public void setWebXml(File webXml) {
        this.webXml = webXml;
    }

    @OutputDirectory
    public File getDestinationDir() {
        return this.destinationDir;
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    public CopySpec from(Object ... input) {
        return this.root.from(input);
    }
}

