/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.gradle.plugins.gwt;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecResult;
import org.wisepersist.gradle.plugins.gwt.GwtJsInteropExportsOptions;
import org.wisepersist.gradle.plugins.gwt.JsInteropMode;
import org.wisepersist.gradle.plugins.gwt.LogLevel;
import org.wisepersist.gradle.plugins.gwt.MethodNameDisplayMode;
import org.wisepersist.gradle.plugins.gwt.internal.GwtVersion;

public abstract class AbstractGwtActionTask
extends DefaultTask {
    private static final Logger logger = Logging.getLogger(AbstractGwtActionTask.class);
    private String gwtVersion;
    private List<String> modules;
    private FileCollection src;
    private FileCollection classpath;
    private String minHeapSize;
    private String maxHeapSize;
    private final String main;
    private List<Object> args = new ArrayList<Object>();
    private List<Object> jvmArgs = new ArrayList<Object>();
    private List<String> extraJvmArgs = new ArrayList<String>();
    private boolean debug;
    private LogLevel logLevel;
    private String sourceLevel;
    private Boolean incremental;
    private JsInteropMode jsInteropMode;
    private GwtJsInteropExportsOptions jsInteropExports;
    private MethodNameDisplayMode methodNameDisplayMode;

    public AbstractGwtActionTask(String main) {
        this.main = main;
    }

    @TaskAction
    public void exec() {
        ExecResult execResult = this.getProject().javaexec(javaExecSpec -> {
            if (this.getSrc() == null) {
                throw new InvalidUserDataException("No Source is set");
            }
            if (this.getClasspath() == null) {
                throw new InvalidUserDataException("Classpath is not set");
            }
            if (this.getModules() == null || this.getModules().isEmpty()) {
                throw new InvalidUserDataException("No module[s] given");
            }
            if (this.getJsInteropExports().shouldGenerate() && this.getJsInteropExports().getIncludePatterns().isEmpty() && !this.getJsInteropExports().getExcludePatterns().isEmpty()) {
                throw new InvalidUserDataException("No include pattern(s) for JsInterop exports given");
            }
            javaExecSpec.getMainClass().set((Object)this.main);
            javaExecSpec.setDebug(this.isDebug());
            javaExecSpec.setMinHeapSize(this.getMinHeapSize());
            javaExecSpec.setMaxHeapSize(this.getMaxHeapSize());
            FileCollection classpath = this.getClasspath();
            if (this.prependSrcToClasspath()) {
                classpath = this.getSrc().plus(classpath);
            }
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                javaExecSpec.environment("CLASSPATH", (Object)classpath.getAsPath());
            } else {
                javaExecSpec.setClasspath(classpath);
            }
            this.argIfSet("-XjsInteropMode", (Object)this.getJsInteropMode());
            if (this.doesSupportJsInteropExports(GwtVersion.parse(this.getGwtVersion()))) {
                this.argOnOff(this.getJsInteropExports().shouldGenerate(), "-generateJsInteropExports", "-nogenerateJsInteropExports");
                this.getJsInteropExports().getIncludePatterns().forEach(includePattern -> this.argIfSet("-includeJsInteropExports", includePattern));
                this.getJsInteropExports().getExcludePatterns().forEach(excludePattern -> this.argIfSet("-excludeJsInteropExports", excludePattern));
            }
            this.argIfSet("-XmethodNameDisplayMode", (Object)this.getMethodNameDisplayMode());
            this.argOnOff(this.getIncremental(), "-incremental", "-noincremental");
            this.argIfSet("-sourceLevel", this.getSourceLevel());
            this.argIfSet("-logLevel", (Object)this.getLogLevel());
            this.addArgs();
            for (String extraJvmArg : this.getExtraJvmArgs()) {
                this.jvmArgs.add(extraJvmArg);
            }
            javaExecSpec.jvmArgs(this.jvmArgs);
            javaExecSpec.args(this.args);
            javaExecSpec.args(this.getModules());
            logger.info("main={}, gwtVersion={}, modules={}, minHeapSize={}, maxHeapSize={},  extraJvmArgs={} ", new Object[]{this.main, this.getGwtVersion(), this.getModules(), this.getMinHeapSize(), this.getMaxHeapSize(), this.getExtraJvmArgs()});
        });
        execResult.assertNormalExitValue().rethrowFailure();
    }

    protected boolean prependSrcToClasspath() {
        return true;
    }

    private boolean doesSupportJsInteropExports(GwtVersion parsedGwtVersion) {
        return parsedGwtVersion != null && parsedGwtVersion.getMajor() >= 2 && parsedGwtVersion.getMinor() >= 8;
    }

    @Optional
    @Input
    public String getGwtVersion() {
        return this.gwtVersion;
    }

    public void setGwtVersion(String gwtVersion) {
        this.gwtVersion = gwtVersion;
    }

    @Input
    public List<String> getModules() {
        return this.modules;
    }

    public void setModules(List<String> modules) {
        this.modules = modules;
    }

    protected void args(Object ... args) {
        this.args.addAll(Arrays.asList(args));
    }

    protected void jvmArgs(Object ... args) {
        this.jvmArgs.addAll(Arrays.asList(args));
    }

    protected void argIfEnabled(Boolean condition, String arg) {
        if (Boolean.TRUE.equals(condition)) {
            this.args(arg);
        }
    }

    protected void argOnOff(Boolean condition, String onArg, String offArg) {
        if (Boolean.TRUE.equals(condition)) {
            this.args(onArg);
        } else if (Boolean.FALSE.equals(condition)) {
            this.args(offArg);
        }
    }

    protected void dirArgIfSet(String arg, File dir) {
        if (dir != null) {
            dir.mkdirs();
            this.args(arg, dir);
        }
    }

    protected void argIfSet(String arg, Object value) {
        if (value != null) {
            this.args(arg, value);
        }
    }

    protected abstract void addArgs();

    @Input
    protected boolean isDevTask() {
        return true;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public FileCollection getSrc() {
        return this.src;
    }

    public void setSrc(FileCollection src) {
        this.src = src;
    }

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Input
    public String getMinHeapSize() {
        return this.minHeapSize;
    }

    public void setMinHeapSize(String minHeapSize) {
        this.minHeapSize = minHeapSize;
    }

    @Input
    public String getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public void setMaxHeapSize(String maxHeapSize) {
        this.maxHeapSize = maxHeapSize;
    }

    @Input
    public List<String> getExtraJvmArgs() {
        return this.extraJvmArgs;
    }

    public void setExtraJvmArgs(List<String> extraJvmArgs) {
        this.extraJvmArgs = extraJvmArgs;
    }

    @Input
    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Optional
    @Input
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Optional
    @Input
    public String getSourceLevel() {
        return this.sourceLevel;
    }

    public void setSourceLevel(String sourceLevel) {
        this.sourceLevel = sourceLevel;
    }

    @Optional
    @Input
    public Boolean getIncremental() {
        return this.incremental;
    }

    public void setIncremental(Boolean incremental) {
        this.incremental = incremental;
    }

    @Optional
    @Input
    public JsInteropMode getJsInteropMode() {
        return this.jsInteropMode;
    }

    public void setJsInteropMode(JsInteropMode jsInteropMode) {
        this.jsInteropMode = jsInteropMode;
    }

    @Input
    public GwtJsInteropExportsOptions getJsInteropExports() {
        return this.jsInteropExports;
    }

    public void setJsInteropExports(GwtJsInteropExportsOptions jsInteropExports) {
        this.jsInteropExports = jsInteropExports;
    }

    @Optional
    @Input
    public MethodNameDisplayMode getMethodNameDisplayMode() {
        return this.methodNameDisplayMode;
    }

    public void setMethodNameDisplayMode(MethodNameDisplayMode methodNameDisplayMode) {
        this.methodNameDisplayMode = methodNameDisplayMode;
    }
}

