/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.gradle.plugins.gwt;

import java.io.File;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.wisepersist.gradle.plugins.gwt.AbstractGwtTask;
import org.wisepersist.gradle.plugins.gwt.GwtDevOptions;
import org.wisepersist.gradle.plugins.gwt.GwtPluginExtension;
import org.wisepersist.gradle.plugins.gwt.internal.GwtDevOptionsImpl;

public class GwtDev
extends AbstractGwtTask
implements GwtDevOptions {
    private final GwtDevOptions options = new GwtDevOptionsImpl();
    private String modulePathPrefix;

    public GwtDev() {
        super("com.google.gwt.dev.DevMode");
        this.getOutputs().upToDateWhen(task -> false);
    }

    @Override
    protected void addArgs() {
        super.addArgs();
        this.argIfEnabled(this.getNoserver(), "-noserver");
        this.argIfSet("-port", Boolean.TRUE.equals(this.getAutoPort()) ? "auto" : this.getPort());
        this.argIfSet("-whitelist", this.getWhitelist());
        this.argIfSet("-blacklist", this.getBlacklist());
        this.argIfSet("-logdir", this.getLogDir());
        this.argIfSet("-bindAddress", this.getBindAddress());
        this.argIfSet("-codeServerPort", Boolean.TRUE.equals(this.getAutoCodeServerPort()) ? "auto" : this.getCodeServerPort());
        this.argIfSet("-server", this.getServer());
        this.argIfSet("-startupUrl", this.getStartupUrl());
        this.argOnOff(this.getSuperDevMode(), "-superDevMode", "-nosuperDevMode");
        this.argOnOff(this.getStartServer(), "-startServer", "-nostartServer");
        this.argIfSet("-XmethodNameDisplayMode", (Object)this.getMethodNameDisplayMode());
        this.argIfSet("-modulePathPrefix", this.getModulePathPrefix());
        this.argIfSet("-logLevel", (Object)this.getLogLevel());
    }

    protected void configure(GwtPluginExtension gwtPluginExtension) {
        GwtDevOptions options = gwtPluginExtension.getDev();
        ConventionMapping conventionMapping = ((IConventionAware)this).getConventionMapping();
        conventionMapping.map("noserver", () -> options.getNoserver());
        conventionMapping.map("port", () -> options.getPort());
        conventionMapping.map("autoPort", () -> options.getAutoPort());
        conventionMapping.map("whitelist", () -> options.getWhitelist());
        conventionMapping.map("blacklist", () -> options.getBlacklist());
        conventionMapping.map("logDir", () -> options.getLogDir());
        conventionMapping.map("bindAddress", () -> options.getBindAddress());
        conventionMapping.map("codeServerPort", () -> options.getCodeServerPort());
        conventionMapping.map("autoCodeServerPort", () -> options.getAutoCodeServerPort());
        conventionMapping.map("server", () -> options.getServer());
        conventionMapping.map("startupUrl", () -> options.getStartupUrl());
        conventionMapping.map("superDevMode", () -> options.getSuperDevMode());
        conventionMapping.map("startServer", () -> options.getStartServer());
        conventionMapping.map("modulePathPrefix", () -> gwtPluginExtension.getModulePathPrefix());
    }

    @Override
    @Optional
    @Input
    public Boolean getNoserver() {
        return this.options.getNoserver();
    }

    @Override
    public void setNoserver(Boolean noserver) {
        this.options.setNoserver(noserver);
    }

    @Override
    @Optional
    @Input
    public Integer getPort() {
        return this.options.getPort();
    }

    @Override
    public void setPort(Integer port) {
        this.options.setPort(port);
    }

    @Override
    @Optional
    @Input
    public String getWhitelist() {
        return this.options.getWhitelist();
    }

    @Override
    public void setWhitelist(String whitelist) {
        this.options.setWhitelist(whitelist);
    }

    @Override
    @Optional
    @Input
    public String getBlacklist() {
        return this.options.getBlacklist();
    }

    @Override
    public void setBlacklist(String blacklist) {
        this.options.setBlacklist(blacklist);
    }

    @Override
    @OutputDirectory
    public File getLogDir() {
        return this.options.getLogDir();
    }

    @Override
    public void setLogDir(File logDir) {
        this.options.setLogDir(logDir);
    }

    @Override
    @Optional
    @Input
    public String getBindAddress() {
        return this.options.getBindAddress();
    }

    @Override
    public void setBindAddress(String bindAddress) {
        this.options.setBindAddress(bindAddress);
    }

    @Override
    @Optional
    @Input
    public Integer getCodeServerPort() {
        return this.options.getCodeServerPort();
    }

    @Override
    public void setCodeServerPort(Integer codeServerPort) {
        this.options.setCodeServerPort(codeServerPort);
    }

    @Override
    @Optional
    @Input
    public String getServer() {
        return this.options.getServer();
    }

    @Override
    public void setServer(String server) {
        this.options.setServer(server);
    }

    @Override
    @Optional
    @Input
    public String getStartupUrl() {
        return this.options.getStartupUrl();
    }

    @Override
    public void setStartupUrl(String startupUrl) {
        this.options.setStartupUrl(startupUrl);
    }

    @Override
    @Optional
    @Input
    public Boolean getAutoPort() {
        return this.options.getAutoPort();
    }

    @Override
    public void setAutoPort(Boolean autoPort) {
        this.options.setAutoPort(autoPort);
    }

    @Override
    @Optional
    @Input
    public Boolean getAutoCodeServerPort() {
        return this.options.getAutoCodeServerPort();
    }

    @Override
    public void setAutoCodeServerPort(Boolean autoCodeServerPort) {
        this.options.setAutoCodeServerPort(autoCodeServerPort);
    }

    @Override
    @Optional
    @Input
    public Boolean getSuperDevMode() {
        return this.options.getSuperDevMode();
    }

    @Override
    public void setSuperDevMode(Boolean superDevMode) {
        this.options.setSuperDevMode(superDevMode);
    }

    @Override
    @Optional
    @Input
    public Boolean getStartServer() {
        return this.options.getStartServer();
    }

    @Override
    public void setStartServer(Boolean startServer) {
        this.options.setStartServer(startServer);
    }

    @Optional
    @Input
    public String getModulePathPrefix() {
        return this.modulePathPrefix;
    }

    public void setModulePathPrefix(String modulePathPrefix) {
        this.modulePathPrefix = modulePathPrefix;
    }
}

