/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.gradle.plugins.gwt;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.War;
import org.wisepersist.gradle.plugins.gwt.ExplodedWar;
import org.wisepersist.gradle.plugins.gwt.GwtBasePlugin;
import org.wisepersist.gradle.plugins.gwt.GwtCompile;
import org.wisepersist.gradle.plugins.gwt.GwtDev;
import org.wisepersist.gradle.plugins.gwt.GwtDraftCompile;
import org.wisepersist.gradle.plugins.gwt.GwtPluginExtension;

public class GwtWarPlugin
implements Plugin<Project> {
    public static final String TASK_WAR_TEMPLATE = "warTemplate";
    public static final String TASK_DRAFT_WAR = "draftWar";
    public static final String TASK_GWT_DEV = "gwtDev";
    public static final String TASK_GWT_SUPER_DEV = "gwtSuperDev";
    private static final Logger logger = Logging.getLogger(GwtWarPlugin.class);

    public void apply(Project project) {
        project.getPlugins().apply(WarPlugin.class);
        GwtBasePlugin gwtBasePlugin = (GwtBasePlugin)project.getPlugins().apply(GwtBasePlugin.class);
        GwtPluginExtension extension = gwtBasePlugin.getExtension();
        GwtCompile compileTask = (GwtCompile)project.getTasks().getByName("compileGwt");
        GwtDraftCompile draftCompileTask = (GwtDraftCompile)project.getTasks().getByName("draftCompileGwt");
        TaskProvider warTaskProvider = project.getTasks().named("war", War.class);
        logger.debug("Configuring war plugin with GWT settings");
        project.afterEvaluate(p -> warTaskProvider.configure(warTask -> {
            ConfigurableFileCollection files = project.files(new Object[]{compileTask.getWar()}).builtBy(new Object[]{compileTask});
            String modulePathPrefix = extension.getModulePathPrefix();
            if (modulePathPrefix == null || modulePathPrefix.isEmpty()) {
                warTask.from(new Object[]{files});
                return;
            }
            warTask.into((Object)modulePathPrefix, spec -> {
                spec.from(new Object[]{files});
                spec.exclude(new String[]{"WEB-INF"});
            });
            warTask.into((Object)"", spec -> {
                spec.from(new Object[]{files});
                spec.include(new String[]{"WEB-INF"});
            });
        }));
        project.getTasks().register(TASK_WAR_TEMPLATE, ExplodedWar.class, task -> {
            WarPluginConvention warPluginConvention = (WarPluginConvention)project.getConvention().getPlugins().get("war");
            task.setGroup("GWT");
            Object[] objectArray = new Object[1];
            objectArray[0] = () -> ((WarPluginConvention)warPluginConvention).getWebAppDir();
            task.from(objectArray);
            task.dependsOn(new Object[]{() -> ((SourceSet)((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main")).getRuntimeClasspath()});
            task.classpath(warTaskProvider.map(War::getClasspath));
            ((IConventionAware)task).getConventionMapping().map("destinationDir", extension::getDevWar);
            task.setDescription("Creates an exploded web application template to be used by GWT dev mode and eclipse to ensure src/main/webapp stays clean");
        });
        project.getTasks().register(TASK_GWT_DEV, GwtDev.class, task -> {
            task.setDescription("Runs the GWT development mode");
            ((IConventionAware)task).getConventionMapping().map("war", extension::getDevWar);
            task.dependsOn(new Object[]{project.getTasks().named("classes")});
            task.dependsOn(new Object[]{project.getTasks().named(TASK_WAR_TEMPLATE)});
        });
        project.getTasks().register(TASK_DRAFT_WAR, War.class, draftWar -> {
            draftWar.from(new Object[]{draftCompileTask.getOutputs()});
            String appendix = "draft";
            draftWar.getArchiveAppendix().convention((Object)appendix);
            draftWar.getArchiveAppendix().set((Object)appendix);
            draftWar.setDescription("Creates a war using the output of the task draftCompileGwt");
        });
    }
}

