/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.gradle.plugins.gwt.internal;

public final class GwtVersion {
    private static final String PARSING_ERROR_MESSAGE_FORMAT = "GWT version %s can not be parsed. Valid versions must have the format major.minor.patch where major and minor are positive integer numbers.";
    private final int major;
    private final int minor;
    private final String patch;

    private GwtVersion(int major, int minor, String patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static GwtVersion parse(String gwtVersion) {
        if (gwtVersion == null || gwtVersion.trim().isEmpty()) {
            return null;
        }
        try {
            String[] versionParts = gwtVersion.split("\\.", 3);
            if (versionParts.length >= 3) {
                return new GwtVersion(Integer.parseUnsignedInt(versionParts[0]), Integer.parseUnsignedInt(versionParts[1]), versionParts[2]);
            }
            if (versionParts.length >= 2) {
                return new GwtVersion(Integer.parseUnsignedInt(versionParts[0]), Integer.parseUnsignedInt(versionParts[1]), "0");
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format(PARSING_ERROR_MESSAGE_FORMAT, gwtVersion), e);
        }
        throw new IllegalArgumentException(String.format(PARSING_ERROR_MESSAGE_FORMAT, gwtVersion));
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getPatch() {
        return this.patch;
    }

    public String toString() {
        return String.format("%d.%d.%s", this.major, this.minor, this.patch);
    }

    public boolean isAtLeast(int majorMin, int minorMin) {
        return this.major > majorMin || this.major == majorMin && this.minor >= minorMin;
    }
}

