/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.gradle.plugins.gwt;

import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.wisepersist.gradle.plugins.gwt.GwtBasePlugin;
import org.wisepersist.gradle.plugins.gwt.GwtEclipseOptions;
import org.wisepersist.gradle.plugins.gwt.GwtPluginExtension;
import org.wisepersist.gradle.plugins.gwt.GwtWarPlugin;
import org.wisepersist.gradle.plugins.gwt.eclipse.GdtOptions;
import org.wisepersist.gradle.plugins.gwt.eclipse.GenerateGdt;
import org.wisepersist.gradle.plugins.gwt.eclipse.internal.GdtOptionsImpl;

public class GwtEclipsePlugin {
    public static final String ECLIPSE_NATURE = "com.gwtplugins.gwt.eclipse.core.gwtNature";
    public static final String ECLIPSE_BUILDER_PROJECT_VALIDATOR = "com.gwtplugins.gwt.eclipse.core.gwtProjectValidator";
    public static final String ECLIPSE_BUILDER_WEBAPP_VALIDATOR = "com.gwtplugins.gdt.eclipse.core.webAppProjectValidator";
    public static final String ECLIPSE_GWT_CONTAINER = "com.gwtplugins.gwt.eclipse.core.GWT_CONTAINER";
    public static final String GENERATE_GDT_TASK = "generateGdt";
    private static final Logger logger = Logging.getLogger(GwtEclipsePlugin.class);
    private Project project;

    public void apply(Project project, GwtBasePlugin gwtBasePlugin) {
        this.project = project;
        project.getPlugins().apply(EclipsePlugin.class);
        GwtPluginExtension extension = gwtBasePlugin.getExtension();
        GwtEclipseOptions eclipseExtension = (GwtEclipseOptions)((ExtensionAware)extension).getExtensions().create("eclipse", GwtEclipseOptions.class, new Object[0]);
        EclipseModel eclipseModel = (EclipseModel)project.getExtensions().getByType(EclipseModel.class);
        logger.debug("Configuring eclipse model with basic GWT settings");
        eclipseModel.getProject().natures(new String[]{ECLIPSE_NATURE});
        eclipseModel.getProject().buildCommand(ECLIPSE_BUILDER_PROJECT_VALIDATOR);
        project.getPlugins().withType(GwtWarPlugin.class, warPlugin -> {
            logger.debug("Configuring eclipse model GWT web application settings");
            eclipseModel.getProject().buildCommand(ECLIPSE_BUILDER_WEBAPP_VALIDATOR);
            project.getTasks().getByName("eclipse").dependsOn(new Object[]{"warTemplate"});
            project.getTasks().getByName(this.getAssociatedCleanTask("eclipse")).dependsOn(new Object[]{this.getAssociatedCleanTask("warTemplate")});
            GdtOptions gdtExtension = (GdtOptions)((ExtensionAware)eclipseExtension).getExtensions().create("gdt", GdtOptionsImpl.class, new Object[0]);
            this.configureGdtExtension(extension, gdtExtension);
            this.configureGenerateGdt(gdtExtension);
            GenerateGdt generateGdt = (GenerateGdt)project.getTasks().create(GENERATE_GDT_TASK, GenerateGdt.class);
            generateGdt.setSettingsFile(project.file((Object)".settings/com.gwtplugins.gdt.eclipse.core.prefs"));
            project.getTasks().getByName("eclipse").dependsOn(new Object[]{generateGdt});
            project.afterEvaluate(p -> {
                File devWar = extension.getDevWar();
                File classes = new File(devWar, "WEB-INF/classes");
                eclipseModel.getClasspath().setDefaultOutputDir(classes);
            });
        });
        project.afterEvaluate(p -> {
            eclipseModel.getClasspath().getPlusConfigurations().add(gwtBasePlugin.getGwtConfiguration());
            if (eclipseExtension.isAddGwtContainer()) {
                logger.debug("Using GWT_CONTAINER for eclipse");
                eclipseModel.getClasspath().getContainers().add(ECLIPSE_GWT_CONTAINER);
                eclipseModel.getClasspath().getMinusConfigurations().add(gwtBasePlugin.getGwtSdkConfiguration());
            } else {
                logger.debug("Not using GWT_CONTAINER for eclipse");
                eclipseModel.getClasspath().getPlusConfigurations().add(gwtBasePlugin.getGwtSdkConfiguration());
            }
        });
    }

    private void configureGdtExtension(GwtPluginExtension extension, GdtOptions gdtExtension) {
        WarPluginConvention warPluginConvention = (WarPluginConvention)this.project.getConvention().getPlugins().get("war");
        ConventionMapping conventionMapping = ((IConventionAware)gdtExtension).getConventionMapping();
        conventionMapping.map("warSrcDir", () -> warPluginConvention.getWebAppDir());
        conventionMapping.map("lastWarOutDir", () -> extension.getDevWar());
        gdtExtension.setWarSrcDirIsOutput(false);
    }

    private void configureGenerateGdt(GdtOptions gdtExtension) {
        this.project.getTasks().withType(GenerateGdt.class, task -> {
            ConventionMapping conventionMapping = ((IConventionAware)task).getConventionMapping();
            conventionMapping.map("warSrcDir", () -> gdtExtension.getWarSrcDir());
            conventionMapping.map("warSrcDirIsOutput", () -> gdtExtension.getWarSrcDirIsOutput());
            conventionMapping.map("lastWarOutDir", () -> gdtExtension.getLastWarOutDir());
        });
    }

    private String getAssociatedCleanTask(String taskName) {
        String first = taskName.substring(0, 1).toUpperCase();
        String rest = taskName.substring(1);
        return "clean" + first + rest;
    }
}

