/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.gradle.plugins.gwt.eclipse;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.wisepersist.gradle.plugins.gwt.eclipse.GdtOptions;
import org.wisepersist.gradle.plugins.gwt.eclipse.internal.GdtOptionsImpl;

public class GenerateGdt
extends DefaultTask
implements GdtOptions {
    private final GdtOptions options = new GdtOptionsImpl();
    @OutputFile
    private File settingsFile;

    @TaskAction
    private void generate() {
        if (this.getSettingsFile() == null || this.getSettingsFile().isDirectory()) {
            throw new IllegalStateException();
        }
        Properties properties = new Properties();
        this.readProperties(properties);
        this.configureProperties(properties);
        this.writeProperties(properties);
    }

    private void configureProperties(Properties properties) {
        if (this.getLastWarOutDir() != null) {
            properties.put("lastWarOutDir", this.getLastWarOutDir().getAbsoluteFile().getPath());
        }
        String warSrcPath = this.getProject().getProjectDir().toURI().relativize(this.getWarSrcDir().toURI()).getPath();
        properties.put("warSrcDir", warSrcPath);
        properties.put("warSrcDirIsOutput", "" + Boolean.TRUE.equals(this.getWarSrcDirIsOutput()));
    }

    private void readProperties(Properties properties) {
        InputStream inputStream = null;
        try {
            inputStream = this.getSettingsFile().exists() ? new FileInputStream(this.getSettingsFile()) : GenerateGdt.class.getResourceAsStream("defaultGdtPrefs.properties");
            properties.load(inputStream);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    private void writeProperties(Properties properties) {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(this.getSettingsFile());
            properties.store(stream, null);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (stream != null) {
                try {
                    ((OutputStream)stream).close();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    @Override
    public void setWarSrcDirIsOutput(Boolean warSrcDirIsOutput) {
        this.options.setWarSrcDirIsOutput(warSrcDirIsOutput);
    }

    @Override
    @Input
    public Boolean getWarSrcDirIsOutput() {
        return this.options.getWarSrcDirIsOutput();
    }

    @Override
    public void setWarSrcDir(File warSrcDir) {
        this.options.setWarSrcDir(warSrcDir);
    }

    @Override
    @InputDirectory
    public File getWarSrcDir() {
        return this.options.getWarSrcDir();
    }

    @Override
    public void setLastWarOutDir(File lastWarOutDir) {
        this.options.setLastWarOutDir(lastWarOutDir);
    }

    @Override
    @InputDirectory
    @Optional
    public File getLastWarOutDir() {
        return this.options.getLastWarOutDir();
    }

    public File getSettingsFile() {
        return this.settingsFile;
    }

    public void setSettingsFile(File settingsFile) {
        this.settingsFile = settingsFile;
    }
}

