/*
 * Copyright (c) 2017 WisePersist.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wisepersist.pinpayments.pojo;

import com.google.gson.annotations.SerializedName;
import org.immutables.gson.Gson;
import org.immutables.value.Value;

/**
 * Transfer result returned from PinPayments REST API.
 *
 * @author delight.wjk@gmail.com
 */
@Gson.TypeAdapters
@Value.Immutable
public interface TransferResult extends TransferBase {

  String token();

  String status();

  @SerializedName("total_debits")
  Integer totalDebits();

  @SerializedName("total_credits")
  Integer totalCredits();

  @SerializedName("created_at")
  String createdAt();

  @SerializedName("paid_at")
  String paidAt();

  @SerializedName("bank_account")
  BankAccountResult bankAccount();
}
