/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.ImmutableRefundListResponse;
import org.wisepersist.pinpayments.pojo.Pagination;
import org.wisepersist.pinpayments.pojo.RefundListResponse;
import org.wisepersist.pinpayments.pojo.RefundResult;

@ParametersAreNonnullByDefault
public final class GsonAdaptersRefundListResponse
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (RefundListResponseTypeAdapter.adapts(type)) {
            return new RefundListResponseTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersRefundListResponse(RefundListResponse)";
    }

    private static class RefundListResponseTypeAdapter
    extends TypeAdapter<RefundListResponse> {
        public final RefundResult responseTypeSample = null;
        public final Pagination paginationTypeSample = null;
        private final TypeAdapter<RefundResult> responseTypeAdapter;
        private final TypeAdapter<Pagination> paginationTypeAdapter;

        RefundListResponseTypeAdapter(Gson gson) {
            this.responseTypeAdapter = gson.getAdapter(RefundResult.class);
            this.paginationTypeAdapter = gson.getAdapter(Pagination.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return RefundListResponse.class == type.getRawType() || ImmutableRefundListResponse.class == type.getRawType();
        }

        public void write(JsonWriter out, RefundListResponse value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeRefundListResponse(out, value);
            }
        }

        public RefundListResponse read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readRefundListResponse(in);
        }

        private void writeRefundListResponse(JsonWriter out, RefundListResponse instance) throws IOException {
            out.beginObject();
            List<RefundResult> responseElements = instance.response();
            out.name("response");
            out.beginArray();
            for (RefundResult e : responseElements) {
                this.responseTypeAdapter.write(out, (Object)e);
            }
            out.endArray();
            out.name("pagination");
            this.paginationTypeAdapter.write(out, (Object)instance.pagination());
            out.endObject();
        }

        private RefundListResponse readRefundListResponse(JsonReader in) throws IOException {
            ImmutableRefundListResponse.Builder builder = ImmutableRefundListResponse.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableRefundListResponse.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'r': {
                    if (!"response".equals(attributeName)) break;
                    this.readInResponse(in, builder);
                    return;
                }
                case 'p': {
                    if (!"pagination".equals(attributeName)) break;
                    this.readInPagination(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInResponse(JsonReader in, ImmutableRefundListResponse.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    RefundResult value = (RefundResult)this.responseTypeAdapter.read(in);
                    builder.addResponse(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                RefundResult value = (RefundResult)this.responseTypeAdapter.read(in);
                builder.addResponse(value);
            }
        }

        private void readInPagination(JsonReader in, ImmutableRefundListResponse.Builder builder) throws IOException {
            Pagination value = (Pagination)this.paginationTypeAdapter.read(in);
            builder.pagination(value);
        }
    }
}

