/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.BankAccount;
import org.wisepersist.pinpayments.pojo.BankAccountBase;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableBankAccount
implements BankAccount {
    @Nullable
    private final String bankName;
    private final String name;
    private final String bsb;
    private final String number;

    private ImmutableBankAccount(@Nullable String bankName, String name, String bsb, String number) {
        this.bankName = bankName;
        this.name = name;
        this.bsb = bsb;
        this.number = number;
    }

    @Override
    @Nullable
    public String bankName() {
        return this.bankName;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String bsb() {
        return this.bsb;
    }

    @Override
    public String number() {
        return this.number;
    }

    public final ImmutableBankAccount withBankName(@Nullable String value) {
        if (Objects.equal((Object)this.bankName, (Object)value)) {
            return this;
        }
        return new ImmutableBankAccount(value, this.name, this.bsb, this.number);
    }

    public final ImmutableBankAccount withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        return new ImmutableBankAccount(this.bankName, newValue, this.bsb, this.number);
    }

    public final ImmutableBankAccount withBsb(String value) {
        if (this.bsb.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"bsb");
        return new ImmutableBankAccount(this.bankName, this.name, newValue, this.number);
    }

    public final ImmutableBankAccount withNumber(String value) {
        if (this.number.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"number");
        return new ImmutableBankAccount(this.bankName, this.name, this.bsb, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBankAccount && this.equalTo((ImmutableBankAccount)another);
    }

    private boolean equalTo(ImmutableBankAccount another) {
        return Objects.equal((Object)this.bankName, (Object)another.bankName) && this.name.equals(another.name) && this.bsb.equals(another.bsb) && this.number.equals(another.number);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.bankName});
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.bsb.hashCode();
        h += (h << 5) + this.number.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BankAccount").omitNullValues().add("bankName", (Object)this.bankName).add("name", (Object)this.name).add("bsb", (Object)this.bsb).add("number", (Object)this.number).toString();
    }

    public static ImmutableBankAccount copyOf(BankAccount instance) {
        if (instance instanceof ImmutableBankAccount) {
            return (ImmutableBankAccount)instance;
        }
        return ImmutableBankAccount.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_BSB = 2L;
        private static final long INIT_BIT_NUMBER = 4L;
        private long initBits = 7L;
        @Nullable
        private String bankName;
        @Nullable
        private String name;
        @Nullable
        private String bsb;
        @Nullable
        private String number;

        private Builder() {
        }

        public final Builder from(BankAccountBase instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BankAccount instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof BankAccountBase) {
                BankAccountBase instance = (BankAccountBase)object;
                this.bsb(instance.bsb());
                this.name(instance.name());
                this.number(instance.number());
                String bankNameValue = instance.bankName();
                if (bankNameValue != null) {
                    this.bankName(bankNameValue);
                }
            }
        }

        public final Builder bankName(@Nullable String bankName) {
            this.bankName = bankName;
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder bsb(String bsb) {
            this.bsb = (String)Preconditions.checkNotNull((Object)bsb, (Object)"bsb");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder number(String number) {
            this.number = (String)Preconditions.checkNotNull((Object)number, (Object)"number");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableBankAccount build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBankAccount(this.bankName, this.name, this.bsb, this.number);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("bsb");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("number");
            }
            return "Cannot build BankAccount, some of required attributes are not set " + attributes;
        }
    }
}

