/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.CardListResponse;
import org.wisepersist.pinpayments.pojo.CardResult;
import org.wisepersist.pinpayments.pojo.Pagination;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableCardListResponse
implements CardListResponse {
    private final ImmutableList<CardResult> response;
    private final Pagination pagination;

    private ImmutableCardListResponse(ImmutableList<CardResult> response, Pagination pagination) {
        this.response = response;
        this.pagination = pagination;
    }

    public ImmutableList<CardResult> response() {
        return this.response;
    }

    @Override
    public Pagination pagination() {
        return this.pagination;
    }

    public final ImmutableCardListResponse withResponse(CardResult ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCardListResponse((ImmutableList<CardResult>)newValue, this.pagination);
    }

    public final ImmutableCardListResponse withResponse(Iterable<? extends CardResult> elements) {
        if (this.response == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCardListResponse((ImmutableList<CardResult>)newValue, this.pagination);
    }

    public final ImmutableCardListResponse withPagination(Pagination value) {
        if (this.pagination == value) {
            return this;
        }
        Pagination newValue = (Pagination)Preconditions.checkNotNull((Object)value, (Object)"pagination");
        return new ImmutableCardListResponse(this.response, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCardListResponse && this.equalTo((ImmutableCardListResponse)another);
    }

    private boolean equalTo(ImmutableCardListResponse another) {
        return this.response.equals(another.response) && this.pagination.equals(another.pagination);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.response.hashCode();
        h += (h << 5) + this.pagination.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CardListResponse").omitNullValues().add("response", this.response).add("pagination", (Object)this.pagination).toString();
    }

    public static ImmutableCardListResponse copyOf(CardListResponse instance) {
        if (instance instanceof ImmutableCardListResponse) {
            return (ImmutableCardListResponse)instance;
        }
        return ImmutableCardListResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PAGINATION = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<CardResult> response = ImmutableList.builder();
        @Nullable
        private Pagination pagination;

        private Builder() {
        }

        public final Builder from(CardListResponse instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllResponse(instance.response());
            this.pagination(instance.pagination());
            return this;
        }

        public final Builder addResponse(CardResult element) {
            this.response.add((Object)element);
            return this;
        }

        public final Builder addResponse(CardResult ... elements) {
            this.response.add((Object[])elements);
            return this;
        }

        public final Builder response(Iterable<? extends CardResult> elements) {
            this.response = ImmutableList.builder();
            return this.addAllResponse(elements);
        }

        public final Builder addAllResponse(Iterable<? extends CardResult> elements) {
            this.response.addAll(elements);
            return this;
        }

        public final Builder pagination(Pagination pagination) {
            this.pagination = (Pagination)Preconditions.checkNotNull((Object)pagination, (Object)"pagination");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableCardListResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCardListResponse(this.response.build(), this.pagination);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pagination");
            }
            return "Cannot build CardListResponse, some of required attributes are not set " + attributes;
        }
    }
}

