/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.CardResponse;
import org.wisepersist.pinpayments.pojo.CardResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableCardResponse
implements CardResponse {
    private final CardResult response;

    private ImmutableCardResponse(CardResult response) {
        this.response = response;
    }

    @Override
    public CardResult response() {
        return this.response;
    }

    public final ImmutableCardResponse withResponse(CardResult value) {
        if (this.response == value) {
            return this;
        }
        CardResult newValue = (CardResult)Preconditions.checkNotNull((Object)value, (Object)"response");
        return new ImmutableCardResponse(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCardResponse && this.equalTo((ImmutableCardResponse)another);
    }

    private boolean equalTo(ImmutableCardResponse another) {
        return this.response.equals(another.response);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.response.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CardResponse").omitNullValues().add("response", (Object)this.response).toString();
    }

    public static ImmutableCardResponse copyOf(CardResponse instance) {
        if (instance instanceof ImmutableCardResponse) {
            return (ImmutableCardResponse)instance;
        }
        return ImmutableCardResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RESPONSE = 1L;
        private long initBits = 1L;
        @Nullable
        private CardResult response;

        private Builder() {
        }

        public final Builder from(CardResponse instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.response(instance.response());
            return this;
        }

        public final Builder response(CardResult response) {
            this.response = (CardResult)Preconditions.checkNotNull((Object)response, (Object)"response");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableCardResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCardResponse(this.response);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("response");
            }
            return "Cannot build CardResponse, some of required attributes are not set " + attributes;
        }
    }
}

