/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.ErrorResponse;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableErrorResponse
implements ErrorResponse {
    private final String error;
    private final String errorDescription;

    private ImmutableErrorResponse(String error, String errorDescription) {
        this.error = error;
        this.errorDescription = errorDescription;
    }

    @Override
    public String error() {
        return this.error;
    }

    @Override
    public String errorDescription() {
        return this.errorDescription;
    }

    public final ImmutableErrorResponse withError(String value) {
        if (this.error.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"error");
        return new ImmutableErrorResponse(newValue, this.errorDescription);
    }

    public final ImmutableErrorResponse withErrorDescription(String value) {
        if (this.errorDescription.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"errorDescription");
        return new ImmutableErrorResponse(this.error, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableErrorResponse && this.equalTo((ImmutableErrorResponse)another);
    }

    private boolean equalTo(ImmutableErrorResponse another) {
        return this.error.equals(another.error) && this.errorDescription.equals(another.errorDescription);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.error.hashCode();
        h += (h << 5) + this.errorDescription.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ErrorResponse").omitNullValues().add("error", (Object)this.error).add("errorDescription", (Object)this.errorDescription).toString();
    }

    public static ImmutableErrorResponse copyOf(ErrorResponse instance) {
        if (instance instanceof ImmutableErrorResponse) {
            return (ImmutableErrorResponse)instance;
        }
        return ImmutableErrorResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ERROR = 1L;
        private static final long INIT_BIT_ERROR_DESCRIPTION = 2L;
        private long initBits = 3L;
        @Nullable
        private String error;
        @Nullable
        private String errorDescription;

        private Builder() {
        }

        public final Builder from(ErrorResponse instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.error(instance.error());
            this.errorDescription(instance.errorDescription());
            return this;
        }

        public final Builder error(String error) {
            this.error = (String)Preconditions.checkNotNull((Object)error, (Object)"error");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder errorDescription(String errorDescription) {
            this.errorDescription = (String)Preconditions.checkNotNull((Object)errorDescription, (Object)"errorDescription");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableErrorResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableErrorResponse(this.error, this.errorDescription);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("error");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("errorDescription");
            }
            return "Cannot build ErrorResponse, some of required attributes are not set " + attributes;
        }
    }
}

