/*
 * Copyright (c) 2017 WisePersist.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wisepersist.pinpayments.api.impl;

import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisepersist.apuava.http.HttpResponse;
import org.wisepersist.pinpayments.ParamsHelper;
import org.wisepersist.pinpayments.api.CardTokensApi;
import org.wisepersist.pinpayments.pojo.Card;
import org.wisepersist.pinpayments.pojo.CardResponse;
import org.wisepersist.pinpayments.pojo.ImmutableCardResponse;

/**
 * Implementation of {@link CardTokensApi} interface.
 *
 * @author delight.wjk@gmail.com
 */
public class CardTokensApiImpl extends AbstractBaseApi implements CardTokensApi {

  private static final Logger log = LoggerFactory.getLogger(CardTokensApiImpl.class); // NOPMD

  @Inject
  private ParamsHelper paramsHelper;
  @Inject
  private Gson gson;

  @Override
  public final CardResponse create(final Card card) throws IOException {
    final Map<String, String> flatParams = paramsHelper.toFlatParams(card);
    final String url = getApiUrl();
    final HttpResponse httpResponse = httpTransportForPost()
        .setUrl(url)
        .addParams(flatParams)
        .execute();
    log.debug("httpResponse: " + httpResponse);
    return gson.fromJson(httpResponse.getContent(), ImmutableCardResponse.class);
  }

  @Override
  protected final String getApiName() {
    return "cards";
  }
}
