/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.inject.AbstractModule;
import java.util.ServiceLoader;
import org.wisepersist.pinpayments.annotation.PinBaseUrl;
import org.wisepersist.pinpayments.annotation.PinSecretKey;
import org.wisepersist.pinpayments.annotation.PinVersion;

public class PinPaymentsModule
extends AbstractModule {
    private static final String PIN_BASEURL_TEST = "https://test-api.pin.net.au";
    private static final String PIN_BASEURL_PROD = "https://api.pin.net.au";
    private static final String PIN_VERSION = "1";
    private final Env env;
    private final String pinSecretKey;

    public PinPaymentsModule(Env env, String pinSecretKey) {
        this.env = env;
        this.pinSecretKey = pinSecretKey;
    }

    protected final void configure() {
        this.bind(Gson.class).toInstance((Object)this.createGson());
        if (this.env == Env.Prod) {
            this.bind(String.class).annotatedWith(PinBaseUrl.class).toInstance((Object)PIN_BASEURL_PROD);
        } else {
            this.bind(String.class).annotatedWith(PinBaseUrl.class).toInstance((Object)PIN_BASEURL_TEST);
        }
        this.bind(String.class).annotatedWith(PinVersion.class).toInstance((Object)PIN_VERSION);
        this.bind(String.class).annotatedWith(PinSecretKey.class).toInstance((Object)this.pinSecretKey);
    }

    private Gson createGson() {
        GsonBuilder gsonBuilder = new GsonBuilder().serializeNulls();
        for (TypeAdapterFactory factory : ServiceLoader.load(TypeAdapterFactory.class)) {
            gsonBuilder.registerTypeAdapterFactory(factory);
        }
        return gsonBuilder.create();
    }

    public static enum Env {
        Test,
        Prod;

    }
}

