/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.api.impl;

import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisepersist.apuava.http.HttpResponse;
import org.wisepersist.pinpayments.ParamsHelper;
import org.wisepersist.pinpayments.api.CardTokensApi;
import org.wisepersist.pinpayments.api.impl.AbstractBaseApi;
import org.wisepersist.pinpayments.pojo.Card;
import org.wisepersist.pinpayments.pojo.CardResponse;
import org.wisepersist.pinpayments.pojo.ImmutableCardResponse;

public class CardTokensApiImpl
extends AbstractBaseApi
implements CardTokensApi {
    private static final Logger log = LoggerFactory.getLogger(CardTokensApiImpl.class);
    @Inject
    private ParamsHelper paramsHelper;
    @Inject
    private Gson gson;

    @Override
    public final CardResponse create(Card card) throws IOException {
        Map<String, String> flatParams = this.paramsHelper.toFlatParams(card);
        String url = this.getApiUrl();
        HttpResponse httpResponse = this.httpTransportForPost().setUrl(url).addParams(flatParams).execute();
        log.debug("httpResponse: " + httpResponse);
        return (CardResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableCardResponse.class);
    }

    @Override
    protected final String getApiName() {
        return "cards";
    }
}

