/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.api.impl;

import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisepersist.apuava.http.HttpResponse;
import org.wisepersist.pinpayments.ParamsHelper;
import org.wisepersist.pinpayments.api.RefundsApi;
import org.wisepersist.pinpayments.api.impl.AbstractBaseApi;
import org.wisepersist.pinpayments.pojo.ImmutableRefundListResponse;
import org.wisepersist.pinpayments.pojo.ImmutableRefundResponse;
import org.wisepersist.pinpayments.pojo.Refund;
import org.wisepersist.pinpayments.pojo.RefundListResponse;
import org.wisepersist.pinpayments.pojo.RefundResponse;

public class RefundsApiImpl
extends AbstractBaseApi
implements RefundsApi {
    private static final Logger log = LoggerFactory.getLogger(RefundsApiImpl.class);
    @Inject
    private ParamsHelper paramsHelper;
    @Inject
    private Gson gson;

    @Override
    public final RefundListResponse list(int page) throws IOException {
        return this.executeList(this.getApiUrl(), ImmutableRefundListResponse.class);
    }

    @Override
    public final RefundResponse fetch(String refundToken) throws IOException {
        String url = String.format("%s/%s", this.getApiUrl(), refundToken);
        HttpResponse httpResponse = this.httpTransportForGet().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return (RefundResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableRefundResponse.class);
    }

    @Override
    public final RefundResponse create(String chargeToken, Refund refund) throws IOException {
        Map<String, String> flatParams = this.paramsHelper.toFlatParams(refund);
        String url = String.format("%s/charges/%s/refunds", this.getApiBase(), chargeToken);
        HttpResponse httpResponse = this.httpTransportForPost().setUrl(url).addParams(flatParams).execute();
        log.debug("httpResponse: " + httpResponse);
        return (RefundResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableRefundResponse.class);
    }

    @Override
    public final RefundListResponse listForCharge(String chargeToken, int page) throws IOException {
        String url = String.format("%s/charges/%s/refunds", this.getApiBase(), chargeToken);
        HttpResponse httpResponse = this.httpTransportForGet().setUrl(url).execute();
        log.debug("httpResponse: " + httpResponse);
        return (RefundListResponse)this.gson.fromJson(httpResponse.getContent(), ImmutableRefundListResponse.class);
    }

    @Override
    protected final String getApiName() {
        return "refunds";
    }
}

