/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.Balance;
import org.wisepersist.pinpayments.pojo.BalanceResult;
import org.wisepersist.pinpayments.pojo.ImmutableBalanceResult;

@ParametersAreNonnullByDefault
public final class GsonAdaptersBalanceResult
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (BalanceResultTypeAdapter.adapts(type)) {
            return new BalanceResultTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersBalanceResult(BalanceResult)";
    }

    private static class BalanceResultTypeAdapter
    extends TypeAdapter<BalanceResult> {
        public final Balance availableTypeSample = null;
        public final Balance pendingTypeSample = null;
        private final TypeAdapter<Balance> availableTypeAdapter;
        private final TypeAdapter<Balance> pendingTypeAdapter;

        BalanceResultTypeAdapter(Gson gson) {
            this.availableTypeAdapter = gson.getAdapter(Balance.class);
            this.pendingTypeAdapter = gson.getAdapter(Balance.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return BalanceResult.class == type.getRawType() || ImmutableBalanceResult.class == type.getRawType();
        }

        public void write(JsonWriter out, BalanceResult value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeBalanceResult(out, value);
            }
        }

        public BalanceResult read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readBalanceResult(in);
        }

        private void writeBalanceResult(JsonWriter out, BalanceResult instance) throws IOException {
            out.beginObject();
            List<Balance> availableElements = instance.available();
            out.name("available");
            out.beginArray();
            for (Balance e : availableElements) {
                this.availableTypeAdapter.write(out, (Object)e);
            }
            out.endArray();
            List<Balance> pendingElements = instance.pending();
            out.name("pending");
            out.beginArray();
            for (Balance e : pendingElements) {
                this.pendingTypeAdapter.write(out, (Object)e);
            }
            out.endArray();
            out.endObject();
        }

        private BalanceResult readBalanceResult(JsonReader in) throws IOException {
            ImmutableBalanceResult.Builder builder = ImmutableBalanceResult.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableBalanceResult.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'a': {
                    if (!"available".equals(attributeName)) break;
                    this.readInAvailable(in, builder);
                    return;
                }
                case 'p': {
                    if (!"pending".equals(attributeName)) break;
                    this.readInPending(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInAvailable(JsonReader in, ImmutableBalanceResult.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    Balance value = (Balance)this.availableTypeAdapter.read(in);
                    builder.addAvailable(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Balance value = (Balance)this.availableTypeAdapter.read(in);
                builder.addAvailable(value);
            }
        }

        private void readInPending(JsonReader in, ImmutableBalanceResult.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    Balance value = (Balance)this.pendingTypeAdapter.read(in);
                    builder.addPending(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Balance value = (Balance)this.pendingTypeAdapter.read(in);
                builder.addPending(value);
            }
        }
    }
}

