/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.CardListResponse;
import org.wisepersist.pinpayments.pojo.CardResult;
import org.wisepersist.pinpayments.pojo.ImmutableCardListResponse;
import org.wisepersist.pinpayments.pojo.Pagination;

@ParametersAreNonnullByDefault
public final class GsonAdaptersCardListResponse
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (CardListResponseTypeAdapter.adapts(type)) {
            return new CardListResponseTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersCardListResponse(CardListResponse)";
    }

    private static class CardListResponseTypeAdapter
    extends TypeAdapter<CardListResponse> {
        public final CardResult responseTypeSample = null;
        public final Pagination paginationTypeSample = null;
        private final TypeAdapter<CardResult> responseTypeAdapter;
        private final TypeAdapter<Pagination> paginationTypeAdapter;

        CardListResponseTypeAdapter(Gson gson) {
            this.responseTypeAdapter = gson.getAdapter(CardResult.class);
            this.paginationTypeAdapter = gson.getAdapter(Pagination.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return CardListResponse.class == type.getRawType() || ImmutableCardListResponse.class == type.getRawType();
        }

        public void write(JsonWriter out, CardListResponse value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeCardListResponse(out, value);
            }
        }

        public CardListResponse read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readCardListResponse(in);
        }

        private void writeCardListResponse(JsonWriter out, CardListResponse instance) throws IOException {
            out.beginObject();
            List<CardResult> responseElements = instance.response();
            out.name("response");
            out.beginArray();
            for (CardResult e : responseElements) {
                this.responseTypeAdapter.write(out, (Object)e);
            }
            out.endArray();
            out.name("pagination");
            this.paginationTypeAdapter.write(out, (Object)instance.pagination());
            out.endObject();
        }

        private CardListResponse readCardListResponse(JsonReader in) throws IOException {
            ImmutableCardListResponse.Builder builder = ImmutableCardListResponse.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableCardListResponse.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'r': {
                    if (!"response".equals(attributeName)) break;
                    this.readInResponse(in, builder);
                    return;
                }
                case 'p': {
                    if (!"pagination".equals(attributeName)) break;
                    this.readInPagination(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInResponse(JsonReader in, ImmutableCardListResponse.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    CardResult value = (CardResult)this.responseTypeAdapter.read(in);
                    builder.addResponse(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                CardResult value = (CardResult)this.responseTypeAdapter.read(in);
                builder.addResponse(value);
            }
        }

        private void readInPagination(JsonReader in, ImmutableCardListResponse.Builder builder) throws IOException {
            Pagination value = (Pagination)this.paginationTypeAdapter.read(in);
            builder.pagination(value);
        }
    }
}

