/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.CardResult;
import org.wisepersist.pinpayments.pojo.ImmutableCardResult;

@ParametersAreNonnullByDefault
public final class GsonAdaptersCardResult
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (CardResultTypeAdapter.adapts(type)) {
            return new CardResultTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersCardResult(CardResult)";
    }

    private static class CardResultTypeAdapter
    extends TypeAdapter<CardResult> {
        public final Boolean primaryTypeSample = null;
        private final TypeAdapter<Boolean> primaryTypeAdapter;

        CardResultTypeAdapter(Gson gson) {
            this.primaryTypeAdapter = gson.getAdapter(Boolean.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return CardResult.class == type.getRawType() || ImmutableCardResult.class == type.getRawType();
        }

        public void write(JsonWriter out, CardResult value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeCardResult(out, value);
            }
        }

        public CardResult read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readCardResult(in);
        }

        private void writeCardResult(JsonWriter out, CardResult instance) throws IOException {
            out.beginObject();
            out.name("token");
            out.value(instance.token());
            out.name("scheme");
            out.value(instance.scheme());
            out.name("display_number");
            out.value(instance.displayNumber());
            Boolean primaryValue = instance.primary();
            if (primaryValue != null) {
                out.name("primary");
                this.primaryTypeAdapter.write(out, (Object)primaryValue);
            } else if (out.getSerializeNulls()) {
                out.name("primary");
                out.nullValue();
            }
            out.name("expiry_month");
            out.value(instance.expiryMonth());
            out.name("expiry_year");
            out.value(instance.expiryYear());
            out.name("name");
            out.value(instance.name());
            out.name("address_line1");
            out.value(instance.addressLine1());
            String addressLine2Value = instance.addressLine2();
            if (addressLine2Value != null) {
                out.name("address_line2");
                out.value(addressLine2Value);
            } else if (out.getSerializeNulls()) {
                out.name("address_line2");
                out.nullValue();
            }
            out.name("address_city");
            out.value(instance.addressCity());
            String addressPostcodeValue = instance.addressPostcode();
            if (addressPostcodeValue != null) {
                out.name("address_postcode");
                out.value(addressPostcodeValue);
            } else if (out.getSerializeNulls()) {
                out.name("address_postcode");
                out.nullValue();
            }
            String addressStateValue = instance.addressState();
            if (addressStateValue != null) {
                out.name("address_state");
                out.value(addressStateValue);
            } else if (out.getSerializeNulls()) {
                out.name("address_state");
                out.nullValue();
            }
            out.name("address_country");
            out.value(instance.addressCountry());
            out.endObject();
        }

        private CardResult readCardResult(JsonReader in) throws IOException {
            ImmutableCardResult.Builder builder = ImmutableCardResult.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableCardResult.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 't': {
                    if (!"token".equals(attributeName)) break;
                    this.readInToken(in, builder);
                    return;
                }
                case 's': {
                    if (!"scheme".equals(attributeName)) break;
                    this.readInScheme(in, builder);
                    return;
                }
                case 'd': {
                    if (!"display_number".equals(attributeName)) break;
                    this.readInDisplayNumber(in, builder);
                    return;
                }
                case 'p': {
                    if (!"primary".equals(attributeName)) break;
                    this.readInPrimary(in, builder);
                    return;
                }
                case 'e': {
                    if ("expiry_month".equals(attributeName)) {
                        this.readInExpiryMonth(in, builder);
                        return;
                    }
                    if (!"expiry_year".equals(attributeName)) break;
                    this.readInExpiryYear(in, builder);
                    return;
                }
                case 'n': {
                    if (!"name".equals(attributeName)) break;
                    this.readInName(in, builder);
                    return;
                }
                case 'a': {
                    if ("address_line1".equals(attributeName)) {
                        this.readInAddressLine1(in, builder);
                        return;
                    }
                    if ("address_line2".equals(attributeName)) {
                        this.readInAddressLine2(in, builder);
                        return;
                    }
                    if ("address_city".equals(attributeName)) {
                        this.readInAddressCity(in, builder);
                        return;
                    }
                    if ("address_postcode".equals(attributeName)) {
                        this.readInAddressPostcode(in, builder);
                        return;
                    }
                    if ("address_state".equals(attributeName)) {
                        this.readInAddressState(in, builder);
                        return;
                    }
                    if (!"address_country".equals(attributeName)) break;
                    this.readInAddressCountry(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInToken(JsonReader in, ImmutableCardResult.Builder builder) throws IOException {
            builder.token(in.nextString());
        }

        private void readInScheme(JsonReader in, ImmutableCardResult.Builder builder) throws IOException {
            builder.scheme(in.nextString());
        }

        private void readInDisplayNumber(JsonReader in, ImmutableCardResult.Builder builder) throws IOException {
            builder.displayNumber(in.nextString());
        }

        private void readInPrimary(JsonReader in, ImmutableCardResult.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Boolean value = (Boolean)this.primaryTypeAdapter.read(in);
                builder.primary(value);
            }
        }

        private void readInExpiryMonth(JsonReader in, ImmutableCardResult.Builder builder) throws IOException {
            builder.expiryMonth(in.nextString());
        }

        private void readInExpiryYear(JsonReader in, ImmutableCardResult.Builder builder) throws IOException {
            builder.expiryYear(in.nextString());
        }

        private void readInName(JsonReader in, ImmutableCardResult.Builder builder) throws IOException {
            builder.name(in.nextString());
        }

        private void readInAddressLine1(JsonReader in, ImmutableCardResult.Builder builder) throws IOException {
            builder.addressLine1(in.nextString());
        }

        private void readInAddressLine2(JsonReader in, ImmutableCardResult.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.addressLine2(in.nextString());
            }
        }

        private void readInAddressCity(JsonReader in, ImmutableCardResult.Builder builder) throws IOException {
            builder.addressCity(in.nextString());
        }

        private void readInAddressPostcode(JsonReader in, ImmutableCardResult.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.addressPostcode(in.nextString());
            }
        }

        private void readInAddressState(JsonReader in, ImmutableCardResult.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.addressState(in.nextString());
            }
        }

        private void readInAddressCountry(JsonReader in, ImmutableCardResult.Builder builder) throws IOException {
            builder.addressCountry(in.nextString());
        }
    }
}

