/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.ErrorResponse;
import org.wisepersist.pinpayments.pojo.ImmutableErrorResponse;

@ParametersAreNonnullByDefault
public final class GsonAdaptersErrorResponse
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (ErrorResponseTypeAdapter.adapts(type)) {
            return new ErrorResponseTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersErrorResponse(ErrorResponse)";
    }

    private static class ErrorResponseTypeAdapter
    extends TypeAdapter<ErrorResponse> {
        ErrorResponseTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return ErrorResponse.class == type.getRawType() || ImmutableErrorResponse.class == type.getRawType();
        }

        public void write(JsonWriter out, ErrorResponse value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeErrorResponse(out, value);
            }
        }

        public ErrorResponse read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readErrorResponse(in);
        }

        private void writeErrorResponse(JsonWriter out, ErrorResponse instance) throws IOException {
            out.beginObject();
            out.name("error");
            out.value(instance.error());
            out.name("error_description");
            out.value(instance.errorDescription());
            out.endObject();
        }

        private ErrorResponse readErrorResponse(JsonReader in) throws IOException {
            ImmutableErrorResponse.Builder builder = ImmutableErrorResponse.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableErrorResponse.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'e': {
                    if ("error".equals(attributeName)) {
                        this.readInError(in, builder);
                        return;
                    }
                    if (!"error_description".equals(attributeName)) break;
                    this.readInErrorDescription(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInError(JsonReader in, ImmutableErrorResponse.Builder builder) throws IOException {
            builder.error(in.nextString());
        }

        private void readInErrorDescription(JsonReader in, ImmutableErrorResponse.Builder builder) throws IOException {
            builder.errorDescription(in.nextString());
        }
    }
}

