/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.EventListResponse;
import org.wisepersist.pinpayments.pojo.EventResult;
import org.wisepersist.pinpayments.pojo.ImmutableEventListResponse;
import org.wisepersist.pinpayments.pojo.Pagination;

@ParametersAreNonnullByDefault
public final class GsonAdaptersEventListResponse
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (EventListResponseTypeAdapter.adapts(type)) {
            return new EventListResponseTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersEventListResponse(EventListResponse)";
    }

    private static class EventListResponseTypeAdapter
    extends TypeAdapter<EventListResponse> {
        public final EventResult responseTypeSample = null;
        public final Pagination paginationTypeSample = null;
        private final TypeAdapter<EventResult> responseTypeAdapter;
        private final TypeAdapter<Pagination> paginationTypeAdapter;

        EventListResponseTypeAdapter(Gson gson) {
            this.responseTypeAdapter = gson.getAdapter(EventResult.class);
            this.paginationTypeAdapter = gson.getAdapter(Pagination.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return EventListResponse.class == type.getRawType() || ImmutableEventListResponse.class == type.getRawType();
        }

        public void write(JsonWriter out, EventListResponse value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeEventListResponse(out, value);
            }
        }

        public EventListResponse read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readEventListResponse(in);
        }

        private void writeEventListResponse(JsonWriter out, EventListResponse instance) throws IOException {
            out.beginObject();
            List<EventResult> responseElements = instance.response();
            out.name("response");
            out.beginArray();
            for (EventResult e : responseElements) {
                this.responseTypeAdapter.write(out, (Object)e);
            }
            out.endArray();
            out.name("pagination");
            this.paginationTypeAdapter.write(out, (Object)instance.pagination());
            out.endObject();
        }

        private EventListResponse readEventListResponse(JsonReader in) throws IOException {
            ImmutableEventListResponse.Builder builder = ImmutableEventListResponse.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableEventListResponse.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'r': {
                    if (!"response".equals(attributeName)) break;
                    this.readInResponse(in, builder);
                    return;
                }
                case 'p': {
                    if (!"pagination".equals(attributeName)) break;
                    this.readInPagination(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInResponse(JsonReader in, ImmutableEventListResponse.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    EventResult value = (EventResult)this.responseTypeAdapter.read(in);
                    builder.addResponse(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                EventResult value = (EventResult)this.responseTypeAdapter.read(in);
                builder.addResponse(value);
            }
        }

        private void readInPagination(JsonReader in, ImmutableEventListResponse.Builder builder) throws IOException {
            Pagination value = (Pagination)this.paginationTypeAdapter.read(in);
            builder.pagination(value);
        }
    }
}

