/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.BankAccount;
import org.wisepersist.pinpayments.pojo.ImmutableRecipient;
import org.wisepersist.pinpayments.pojo.Recipient;

@ParametersAreNonnullByDefault
public final class GsonAdaptersRecipient
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (RecipientTypeAdapter.adapts(type)) {
            return new RecipientTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersRecipient(Recipient)";
    }

    private static class RecipientTypeAdapter
    extends TypeAdapter<Recipient> {
        public final BankAccount bankAccountTypeSample = null;
        private final TypeAdapter<BankAccount> bankAccountTypeAdapter;

        RecipientTypeAdapter(Gson gson) {
            this.bankAccountTypeAdapter = gson.getAdapter(BankAccount.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return Recipient.class == type.getRawType() || ImmutableRecipient.class == type.getRawType();
        }

        public void write(JsonWriter out, Recipient value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeRecipient(out, value);
            }
        }

        public Recipient read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readRecipient(in);
        }

        private void writeRecipient(JsonWriter out, Recipient instance) throws IOException {
            out.beginObject();
            BankAccount bankAccountValue = instance.bankAccount();
            if (bankAccountValue != null) {
                out.name("bank_account");
                this.bankAccountTypeAdapter.write(out, (Object)bankAccountValue);
            } else if (out.getSerializeNulls()) {
                out.name("bank_account");
                out.nullValue();
            }
            String bankAccountTokenValue = instance.bankAccountToken();
            if (bankAccountTokenValue != null) {
                out.name("bank_account_token");
                out.value(bankAccountTokenValue);
            } else if (out.getSerializeNulls()) {
                out.name("bank_account_token");
                out.nullValue();
            }
            out.name("email");
            out.value(instance.email());
            String nameValue = instance.name();
            if (nameValue != null) {
                out.name("name");
                out.value(nameValue);
            } else if (out.getSerializeNulls()) {
                out.name("name");
                out.nullValue();
            }
            out.endObject();
        }

        private Recipient readRecipient(JsonReader in) throws IOException {
            ImmutableRecipient.Builder builder = ImmutableRecipient.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableRecipient.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'b': {
                    if ("bank_account".equals(attributeName)) {
                        this.readInBankAccount(in, builder);
                        return;
                    }
                    if (!"bank_account_token".equals(attributeName)) break;
                    this.readInBankAccountToken(in, builder);
                    return;
                }
                case 'e': {
                    if (!"email".equals(attributeName)) break;
                    this.readInEmail(in, builder);
                    return;
                }
                case 'n': {
                    if (!"name".equals(attributeName)) break;
                    this.readInName(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInBankAccount(JsonReader in, ImmutableRecipient.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                BankAccount value = (BankAccount)this.bankAccountTypeAdapter.read(in);
                builder.bankAccount(value);
            }
        }

        private void readInBankAccountToken(JsonReader in, ImmutableRecipient.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.bankAccountToken(in.nextString());
            }
        }

        private void readInEmail(JsonReader in, ImmutableRecipient.Builder builder) throws IOException {
            builder.email(in.nextString());
        }

        private void readInName(JsonReader in, ImmutableRecipient.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.name(in.nextString());
            }
        }
    }
}

