/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.BankAccountResult;
import org.wisepersist.pinpayments.pojo.ImmutableRecipientResult;
import org.wisepersist.pinpayments.pojo.RecipientResult;

@ParametersAreNonnullByDefault
public final class GsonAdaptersRecipientResult
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (RecipientResultTypeAdapter.adapts(type)) {
            return new RecipientResultTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersRecipientResult(RecipientResult)";
    }

    private static class RecipientResultTypeAdapter
    extends TypeAdapter<RecipientResult> {
        public final BankAccountResult bankAccountTypeSample = null;
        private final TypeAdapter<BankAccountResult> bankAccountTypeAdapter;

        RecipientResultTypeAdapter(Gson gson) {
            this.bankAccountTypeAdapter = gson.getAdapter(BankAccountResult.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return RecipientResult.class == type.getRawType() || ImmutableRecipientResult.class == type.getRawType();
        }

        public void write(JsonWriter out, RecipientResult value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeRecipientResult(out, value);
            }
        }

        public RecipientResult read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readRecipientResult(in);
        }

        private void writeRecipientResult(JsonWriter out, RecipientResult instance) throws IOException {
            out.beginObject();
            out.name("token");
            out.value(instance.token());
            out.name("created_at");
            out.value(instance.createdAt());
            BankAccountResult bankAccountValue = instance.bankAccount();
            if (bankAccountValue != null) {
                out.name("bank_account");
                this.bankAccountTypeAdapter.write(out, (Object)bankAccountValue);
            } else if (out.getSerializeNulls()) {
                out.name("bank_account");
                out.nullValue();
            }
            out.name("email");
            out.value(instance.email());
            String nameValue = instance.name();
            if (nameValue != null) {
                out.name("name");
                out.value(nameValue);
            } else if (out.getSerializeNulls()) {
                out.name("name");
                out.nullValue();
            }
            out.endObject();
        }

        private RecipientResult readRecipientResult(JsonReader in) throws IOException {
            ImmutableRecipientResult.Builder builder = ImmutableRecipientResult.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableRecipientResult.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 't': {
                    if (!"token".equals(attributeName)) break;
                    this.readInToken(in, builder);
                    return;
                }
                case 'c': {
                    if (!"created_at".equals(attributeName)) break;
                    this.readInCreatedAt(in, builder);
                    return;
                }
                case 'b': {
                    if (!"bank_account".equals(attributeName)) break;
                    this.readInBankAccount(in, builder);
                    return;
                }
                case 'e': {
                    if (!"email".equals(attributeName)) break;
                    this.readInEmail(in, builder);
                    return;
                }
                case 'n': {
                    if (!"name".equals(attributeName)) break;
                    this.readInName(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInToken(JsonReader in, ImmutableRecipientResult.Builder builder) throws IOException {
            builder.token(in.nextString());
        }

        private void readInCreatedAt(JsonReader in, ImmutableRecipientResult.Builder builder) throws IOException {
            builder.createdAt(in.nextString());
        }

        private void readInBankAccount(JsonReader in, ImmutableRecipientResult.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                BankAccountResult value = (BankAccountResult)this.bankAccountTypeAdapter.read(in);
                builder.bankAccount(value);
            }
        }

        private void readInEmail(JsonReader in, ImmutableRecipientResult.Builder builder) throws IOException {
            builder.email(in.nextString());
        }

        private void readInName(JsonReader in, ImmutableRecipientResult.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.name(in.nextString());
            }
        }
    }
}

