/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import org.wisepersist.pinpayments.pojo.ImmutableWebhookResult;
import org.wisepersist.pinpayments.pojo.WebhookResult;

@ParametersAreNonnullByDefault
public final class GsonAdaptersWebhookResult
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (WebhookResultTypeAdapter.adapts(type)) {
            return new WebhookResultTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersWebhookResult(WebhookResult)";
    }

    private static class WebhookResultTypeAdapter
    extends TypeAdapter<WebhookResult> {
        public final Integer retriesTypeSample = null;
        public final HashMap<String, Object> errorsTypeSample = null;
        private final TypeAdapter<Integer> retriesTypeAdapter;
        private final TypeAdapter<HashMap<String, Object>> errorsTypeAdapter;

        WebhookResultTypeAdapter(Gson gson) {
            this.retriesTypeAdapter = gson.getAdapter(Integer.class);
            this.errorsTypeAdapter = gson.getAdapter(TypeToken.getParameterized(HashMap.class, (Type[])new Type[]{String.class, Object.class}));
        }

        static boolean adapts(TypeToken<?> type) {
            return WebhookResult.class == type.getRawType() || ImmutableWebhookResult.class == type.getRawType();
        }

        public void write(JsonWriter out, WebhookResult value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeWebhookResult(out, value);
            }
        }

        public WebhookResult read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readWebhookResult(in);
        }

        private void writeWebhookResult(JsonWriter out, WebhookResult instance) throws IOException {
            out.beginObject();
            out.name("token");
            out.value(instance.token());
            out.name("status");
            out.value(instance.status());
            out.name("url");
            out.value(instance.url());
            out.name("event_token");
            out.value(instance.eventToken());
            out.name("created_at");
            out.value(instance.createdAt());
            out.name("accepted_at");
            out.value(instance.acceptedAt());
            String nextRunValue = instance.nextRun();
            if (nextRunValue != null) {
                out.name("next_run");
                out.value(nextRunValue);
            } else if (out.getSerializeNulls()) {
                out.name("next_run");
                out.nullValue();
            }
            out.name("retries");
            this.retriesTypeAdapter.write(out, (Object)instance.retries());
            out.name("errors");
            this.errorsTypeAdapter.write(out, instance.errors());
            out.endObject();
        }

        private WebhookResult readWebhookResult(JsonReader in) throws IOException {
            ImmutableWebhookResult.Builder builder = ImmutableWebhookResult.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableWebhookResult.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 't': {
                    if (!"token".equals(attributeName)) break;
                    this.readInToken(in, builder);
                    return;
                }
                case 's': {
                    if (!"status".equals(attributeName)) break;
                    this.readInStatus(in, builder);
                    return;
                }
                case 'u': {
                    if (!"url".equals(attributeName)) break;
                    this.readInUrl(in, builder);
                    return;
                }
                case 'e': {
                    if ("event_token".equals(attributeName)) {
                        this.readInEventToken(in, builder);
                        return;
                    }
                    if (!"errors".equals(attributeName)) break;
                    this.readInErrors(in, builder);
                    return;
                }
                case 'c': {
                    if (!"created_at".equals(attributeName)) break;
                    this.readInCreatedAt(in, builder);
                    return;
                }
                case 'a': {
                    if (!"accepted_at".equals(attributeName)) break;
                    this.readInAcceptedAt(in, builder);
                    return;
                }
                case 'n': {
                    if (!"next_run".equals(attributeName)) break;
                    this.readInNextRun(in, builder);
                    return;
                }
                case 'r': {
                    if (!"retries".equals(attributeName)) break;
                    this.readInRetries(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInToken(JsonReader in, ImmutableWebhookResult.Builder builder) throws IOException {
            builder.token(in.nextString());
        }

        private void readInStatus(JsonReader in, ImmutableWebhookResult.Builder builder) throws IOException {
            builder.status(in.nextString());
        }

        private void readInUrl(JsonReader in, ImmutableWebhookResult.Builder builder) throws IOException {
            builder.url(in.nextString());
        }

        private void readInEventToken(JsonReader in, ImmutableWebhookResult.Builder builder) throws IOException {
            builder.eventToken(in.nextString());
        }

        private void readInCreatedAt(JsonReader in, ImmutableWebhookResult.Builder builder) throws IOException {
            builder.createdAt(in.nextString());
        }

        private void readInAcceptedAt(JsonReader in, ImmutableWebhookResult.Builder builder) throws IOException {
            builder.acceptedAt(in.nextString());
        }

        private void readInNextRun(JsonReader in, ImmutableWebhookResult.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.nextRun(in.nextString());
            }
        }

        private void readInRetries(JsonReader in, ImmutableWebhookResult.Builder builder) throws IOException {
            Integer value = (Integer)this.retriesTypeAdapter.read(in);
            builder.retries(value);
        }

        private void readInErrors(JsonReader in, ImmutableWebhookResult.Builder builder) throws IOException {
            HashMap value = (HashMap)this.errorsTypeAdapter.read(in);
            builder.errors(value);
        }
    }
}

