/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.Card;
import org.wisepersist.pinpayments.pojo.CardBase;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableCard
implements Card {
    private final String number;
    private final String cvc;
    private final String expiryMonth;
    private final String expiryYear;
    private final String name;
    private final String addressLine1;
    @Nullable
    private final String addressLine2;
    private final String addressCity;
    @Nullable
    private final String addressPostcode;
    @Nullable
    private final String addressState;
    private final String addressCountry;

    private ImmutableCard(String number, String cvc, String expiryMonth, String expiryYear, String name, String addressLine1, @Nullable String addressLine2, String addressCity, @Nullable String addressPostcode, @Nullable String addressState, String addressCountry) {
        this.number = number;
        this.cvc = cvc;
        this.expiryMonth = expiryMonth;
        this.expiryYear = expiryYear;
        this.name = name;
        this.addressLine1 = addressLine1;
        this.addressLine2 = addressLine2;
        this.addressCity = addressCity;
        this.addressPostcode = addressPostcode;
        this.addressState = addressState;
        this.addressCountry = addressCountry;
    }

    @Override
    public String number() {
        return this.number;
    }

    @Override
    public String cvc() {
        return this.cvc;
    }

    @Override
    public String expiryMonth() {
        return this.expiryMonth;
    }

    @Override
    public String expiryYear() {
        return this.expiryYear;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String addressLine1() {
        return this.addressLine1;
    }

    @Override
    @Nullable
    public String addressLine2() {
        return this.addressLine2;
    }

    @Override
    public String addressCity() {
        return this.addressCity;
    }

    @Override
    @Nullable
    public String addressPostcode() {
        return this.addressPostcode;
    }

    @Override
    @Nullable
    public String addressState() {
        return this.addressState;
    }

    @Override
    public String addressCountry() {
        return this.addressCountry;
    }

    public final ImmutableCard withNumber(String value) {
        if (this.number.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"number");
        return new ImmutableCard(newValue, this.cvc, this.expiryMonth, this.expiryYear, this.name, this.addressLine1, this.addressLine2, this.addressCity, this.addressPostcode, this.addressState, this.addressCountry);
    }

    public final ImmutableCard withCvc(String value) {
        if (this.cvc.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"cvc");
        return new ImmutableCard(this.number, newValue, this.expiryMonth, this.expiryYear, this.name, this.addressLine1, this.addressLine2, this.addressCity, this.addressPostcode, this.addressState, this.addressCountry);
    }

    public final ImmutableCard withExpiryMonth(String value) {
        if (this.expiryMonth.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"expiryMonth");
        return new ImmutableCard(this.number, this.cvc, newValue, this.expiryYear, this.name, this.addressLine1, this.addressLine2, this.addressCity, this.addressPostcode, this.addressState, this.addressCountry);
    }

    public final ImmutableCard withExpiryYear(String value) {
        if (this.expiryYear.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"expiryYear");
        return new ImmutableCard(this.number, this.cvc, this.expiryMonth, newValue, this.name, this.addressLine1, this.addressLine2, this.addressCity, this.addressPostcode, this.addressState, this.addressCountry);
    }

    public final ImmutableCard withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        return new ImmutableCard(this.number, this.cvc, this.expiryMonth, this.expiryYear, newValue, this.addressLine1, this.addressLine2, this.addressCity, this.addressPostcode, this.addressState, this.addressCountry);
    }

    public final ImmutableCard withAddressLine1(String value) {
        if (this.addressLine1.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"addressLine1");
        return new ImmutableCard(this.number, this.cvc, this.expiryMonth, this.expiryYear, this.name, newValue, this.addressLine2, this.addressCity, this.addressPostcode, this.addressState, this.addressCountry);
    }

    public final ImmutableCard withAddressLine2(@Nullable String value) {
        if (Objects.equal((Object)this.addressLine2, (Object)value)) {
            return this;
        }
        return new ImmutableCard(this.number, this.cvc, this.expiryMonth, this.expiryYear, this.name, this.addressLine1, value, this.addressCity, this.addressPostcode, this.addressState, this.addressCountry);
    }

    public final ImmutableCard withAddressCity(String value) {
        if (this.addressCity.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"addressCity");
        return new ImmutableCard(this.number, this.cvc, this.expiryMonth, this.expiryYear, this.name, this.addressLine1, this.addressLine2, newValue, this.addressPostcode, this.addressState, this.addressCountry);
    }

    public final ImmutableCard withAddressPostcode(@Nullable String value) {
        if (Objects.equal((Object)this.addressPostcode, (Object)value)) {
            return this;
        }
        return new ImmutableCard(this.number, this.cvc, this.expiryMonth, this.expiryYear, this.name, this.addressLine1, this.addressLine2, this.addressCity, value, this.addressState, this.addressCountry);
    }

    public final ImmutableCard withAddressState(@Nullable String value) {
        if (Objects.equal((Object)this.addressState, (Object)value)) {
            return this;
        }
        return new ImmutableCard(this.number, this.cvc, this.expiryMonth, this.expiryYear, this.name, this.addressLine1, this.addressLine2, this.addressCity, this.addressPostcode, value, this.addressCountry);
    }

    public final ImmutableCard withAddressCountry(String value) {
        if (this.addressCountry.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"addressCountry");
        return new ImmutableCard(this.number, this.cvc, this.expiryMonth, this.expiryYear, this.name, this.addressLine1, this.addressLine2, this.addressCity, this.addressPostcode, this.addressState, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCard && this.equalTo((ImmutableCard)another);
    }

    private boolean equalTo(ImmutableCard another) {
        return this.number.equals(another.number) && this.cvc.equals(another.cvc) && this.expiryMonth.equals(another.expiryMonth) && this.expiryYear.equals(another.expiryYear) && this.name.equals(another.name) && this.addressLine1.equals(another.addressLine1) && Objects.equal((Object)this.addressLine2, (Object)another.addressLine2) && this.addressCity.equals(another.addressCity) && Objects.equal((Object)this.addressPostcode, (Object)another.addressPostcode) && Objects.equal((Object)this.addressState, (Object)another.addressState) && this.addressCountry.equals(another.addressCountry);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.number.hashCode();
        h += (h << 5) + this.cvc.hashCode();
        h += (h << 5) + this.expiryMonth.hashCode();
        h += (h << 5) + this.expiryYear.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.addressLine1.hashCode();
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.addressLine2});
        h += (h << 5) + this.addressCity.hashCode();
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.addressPostcode});
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.addressState});
        h += (h << 5) + this.addressCountry.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Card").omitNullValues().add("number", (Object)this.number).add("cvc", (Object)this.cvc).add("expiryMonth", (Object)this.expiryMonth).add("expiryYear", (Object)this.expiryYear).add("name", (Object)this.name).add("addressLine1", (Object)this.addressLine1).add("addressLine2", (Object)this.addressLine2).add("addressCity", (Object)this.addressCity).add("addressPostcode", (Object)this.addressPostcode).add("addressState", (Object)this.addressState).add("addressCountry", (Object)this.addressCountry).toString();
    }

    public static ImmutableCard copyOf(Card instance) {
        if (instance instanceof ImmutableCard) {
            return (ImmutableCard)instance;
        }
        return ImmutableCard.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NUMBER = 1L;
        private static final long INIT_BIT_CVC = 2L;
        private static final long INIT_BIT_EXPIRY_MONTH = 4L;
        private static final long INIT_BIT_EXPIRY_YEAR = 8L;
        private static final long INIT_BIT_NAME = 16L;
        private static final long INIT_BIT_ADDRESS_LINE1 = 32L;
        private static final long INIT_BIT_ADDRESS_CITY = 64L;
        private static final long INIT_BIT_ADDRESS_COUNTRY = 128L;
        private long initBits = 255L;
        @Nullable
        private String number;
        @Nullable
        private String cvc;
        @Nullable
        private String expiryMonth;
        @Nullable
        private String expiryYear;
        @Nullable
        private String name;
        @Nullable
        private String addressLine1;
        @Nullable
        private String addressLine2;
        @Nullable
        private String addressCity;
        @Nullable
        private String addressPostcode;
        @Nullable
        private String addressState;
        @Nullable
        private String addressCountry;

        private Builder() {
        }

        public final Builder from(CardBase instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Card instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            CardBase instance;
            if (object instanceof CardBase) {
                String addressStateValue;
                instance = (CardBase)object;
                this.addressCountry(instance.addressCountry());
                String addressPostcodeValue = instance.addressPostcode();
                if (addressPostcodeValue != null) {
                    this.addressPostcode(addressPostcodeValue);
                }
                this.expiryMonth(instance.expiryMonth());
                this.name(instance.name());
                this.addressLine1(instance.addressLine1());
                String addressLine2Value = instance.addressLine2();
                if (addressLine2Value != null) {
                    this.addressLine2(addressLine2Value);
                }
                if ((addressStateValue = instance.addressState()) != null) {
                    this.addressState(addressStateValue);
                }
                this.expiryYear(instance.expiryYear());
                this.addressCity(instance.addressCity());
            }
            if (object instanceof Card) {
                instance = (Card)object;
                this.number(instance.number());
                this.cvc(instance.cvc());
            }
        }

        public final Builder number(String number) {
            this.number = (String)Preconditions.checkNotNull((Object)number, (Object)"number");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder cvc(String cvc) {
            this.cvc = (String)Preconditions.checkNotNull((Object)cvc, (Object)"cvc");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder expiryMonth(String expiryMonth) {
            this.expiryMonth = (String)Preconditions.checkNotNull((Object)expiryMonth, (Object)"expiryMonth");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder expiryYear(String expiryYear) {
            this.expiryYear = (String)Preconditions.checkNotNull((Object)expiryYear, (Object)"expiryYear");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder addressLine1(String addressLine1) {
            this.addressLine1 = (String)Preconditions.checkNotNull((Object)addressLine1, (Object)"addressLine1");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder addressLine2(@Nullable String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        public final Builder addressCity(String addressCity) {
            this.addressCity = (String)Preconditions.checkNotNull((Object)addressCity, (Object)"addressCity");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder addressPostcode(@Nullable String addressPostcode) {
            this.addressPostcode = addressPostcode;
            return this;
        }

        public final Builder addressState(@Nullable String addressState) {
            this.addressState = addressState;
            return this;
        }

        public final Builder addressCountry(String addressCountry) {
            this.addressCountry = (String)Preconditions.checkNotNull((Object)addressCountry, (Object)"addressCountry");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableCard build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCard(this.number, this.cvc, this.expiryMonth, this.expiryYear, this.name, this.addressLine1, this.addressLine2, this.addressCity, this.addressPostcode, this.addressState, this.addressCountry);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("number");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("cvc");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("expiryMonth");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("expiryYear");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("addressLine1");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("addressCity");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("addressCountry");
            }
            return "Cannot build Card, some of required attributes are not set " + attributes;
        }
    }
}

