/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.ChargeResponse;
import org.wisepersist.pinpayments.pojo.ChargeResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableChargeResponse
implements ChargeResponse {
    private final ChargeResult response;

    private ImmutableChargeResponse(ChargeResult response) {
        this.response = response;
    }

    @Override
    public ChargeResult response() {
        return this.response;
    }

    public final ImmutableChargeResponse withResponse(ChargeResult value) {
        if (this.response == value) {
            return this;
        }
        ChargeResult newValue = (ChargeResult)Preconditions.checkNotNull((Object)value, (Object)"response");
        return new ImmutableChargeResponse(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChargeResponse && this.equalTo((ImmutableChargeResponse)another);
    }

    private boolean equalTo(ImmutableChargeResponse another) {
        return this.response.equals(another.response);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.response.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ChargeResponse").omitNullValues().add("response", (Object)this.response).toString();
    }

    public static ImmutableChargeResponse copyOf(ChargeResponse instance) {
        if (instance instanceof ImmutableChargeResponse) {
            return (ImmutableChargeResponse)instance;
        }
        return ImmutableChargeResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RESPONSE = 1L;
        private long initBits = 1L;
        @Nullable
        private ChargeResult response;

        private Builder() {
        }

        public final Builder from(ChargeResponse instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.response(instance.response());
            return this;
        }

        public final Builder response(ChargeResult response) {
            this.response = (ChargeResult)Preconditions.checkNotNull((Object)response, (Object)"response");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableChargeResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChargeResponse(this.response);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("response");
            }
            return "Cannot build ChargeResponse, some of required attributes are not set " + attributes;
        }
    }
}

