/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.CardResult;
import org.wisepersist.pinpayments.pojo.ChargeBase;
import org.wisepersist.pinpayments.pojo.ChargeResult;
import org.wisepersist.pinpayments.pojo.Transfer;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableChargeResult
implements ChargeResult {
    private final String token;
    private final boolean success;
    private final String createdAt;
    private final String statusMessage;
    @Nullable
    private final String errorMessage;
    private final CardResult card;
    private final boolean captured;
    private final boolean authorisationExpired;
    private final ImmutableList<Transfer> transfer;
    private final BigDecimal amountRefunded;
    @Nullable
    private final BigDecimal totalFees;
    @Nullable
    private final BigDecimal merchantEntitlement;
    private final boolean refundPending;
    private final String settlementCurrency;
    private final String email;
    private final String description;
    private final Integer amount;
    private final String ipAddress;
    private final String currency;
    private final ImmutableMap<String, String> metadata;

    private ImmutableChargeResult(String token, boolean success, String createdAt, String statusMessage, @Nullable String errorMessage, CardResult card, boolean captured, boolean authorisationExpired, ImmutableList<Transfer> transfer, BigDecimal amountRefunded, @Nullable BigDecimal totalFees, @Nullable BigDecimal merchantEntitlement, boolean refundPending, String settlementCurrency, String email, String description, Integer amount, String ipAddress, String currency, ImmutableMap<String, String> metadata) {
        this.token = token;
        this.success = success;
        this.createdAt = createdAt;
        this.statusMessage = statusMessage;
        this.errorMessage = errorMessage;
        this.card = card;
        this.captured = captured;
        this.authorisationExpired = authorisationExpired;
        this.transfer = transfer;
        this.amountRefunded = amountRefunded;
        this.totalFees = totalFees;
        this.merchantEntitlement = merchantEntitlement;
        this.refundPending = refundPending;
        this.settlementCurrency = settlementCurrency;
        this.email = email;
        this.description = description;
        this.amount = amount;
        this.ipAddress = ipAddress;
        this.currency = currency;
        this.metadata = metadata;
    }

    @Override
    public String token() {
        return this.token;
    }

    @Override
    public boolean success() {
        return this.success;
    }

    @Override
    public String createdAt() {
        return this.createdAt;
    }

    @Override
    public String statusMessage() {
        return this.statusMessage;
    }

    @Override
    @Nullable
    public String errorMessage() {
        return this.errorMessage;
    }

    @Override
    public CardResult card() {
        return this.card;
    }

    @Override
    public boolean captured() {
        return this.captured;
    }

    @Override
    public boolean authorisationExpired() {
        return this.authorisationExpired;
    }

    public ImmutableList<Transfer> transfer() {
        return this.transfer;
    }

    @Override
    public BigDecimal amountRefunded() {
        return this.amountRefunded;
    }

    @Override
    @Nullable
    public BigDecimal totalFees() {
        return this.totalFees;
    }

    @Override
    @Nullable
    public BigDecimal merchantEntitlement() {
        return this.merchantEntitlement;
    }

    @Override
    public boolean refundPending() {
        return this.refundPending;
    }

    @Override
    public String settlementCurrency() {
        return this.settlementCurrency;
    }

    @Override
    public String email() {
        return this.email;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public Integer amount() {
        return this.amount;
    }

    @Override
    public String ipAddress() {
        return this.ipAddress;
    }

    @Override
    public String currency() {
        return this.currency;
    }

    public ImmutableMap<String, String> metadata() {
        return this.metadata;
    }

    public final ImmutableChargeResult withToken(String value) {
        if (this.token.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"token");
        return new ImmutableChargeResult(newValue, this.success, this.createdAt, this.statusMessage, this.errorMessage, this.card, this.captured, this.authorisationExpired, this.transfer, this.amountRefunded, this.totalFees, this.merchantEntitlement, this.refundPending, this.settlementCurrency, this.email, this.description, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableChargeResult withSuccess(boolean value) {
        if (this.success == value) {
            return this;
        }
        return new ImmutableChargeResult(this.token, value, this.createdAt, this.statusMessage, this.errorMessage, this.card, this.captured, this.authorisationExpired, this.transfer, this.amountRefunded, this.totalFees, this.merchantEntitlement, this.refundPending, this.settlementCurrency, this.email, this.description, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableChargeResult withCreatedAt(String value) {
        if (this.createdAt.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"createdAt");
        return new ImmutableChargeResult(this.token, this.success, newValue, this.statusMessage, this.errorMessage, this.card, this.captured, this.authorisationExpired, this.transfer, this.amountRefunded, this.totalFees, this.merchantEntitlement, this.refundPending, this.settlementCurrency, this.email, this.description, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableChargeResult withStatusMessage(String value) {
        if (this.statusMessage.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"statusMessage");
        return new ImmutableChargeResult(this.token, this.success, this.createdAt, newValue, this.errorMessage, this.card, this.captured, this.authorisationExpired, this.transfer, this.amountRefunded, this.totalFees, this.merchantEntitlement, this.refundPending, this.settlementCurrency, this.email, this.description, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableChargeResult withErrorMessage(@Nullable String value) {
        if (Objects.equal((Object)this.errorMessage, (Object)value)) {
            return this;
        }
        return new ImmutableChargeResult(this.token, this.success, this.createdAt, this.statusMessage, value, this.card, this.captured, this.authorisationExpired, this.transfer, this.amountRefunded, this.totalFees, this.merchantEntitlement, this.refundPending, this.settlementCurrency, this.email, this.description, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableChargeResult withCard(CardResult value) {
        if (this.card == value) {
            return this;
        }
        CardResult newValue = (CardResult)Preconditions.checkNotNull((Object)value, (Object)"card");
        return new ImmutableChargeResult(this.token, this.success, this.createdAt, this.statusMessage, this.errorMessage, newValue, this.captured, this.authorisationExpired, this.transfer, this.amountRefunded, this.totalFees, this.merchantEntitlement, this.refundPending, this.settlementCurrency, this.email, this.description, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableChargeResult withCaptured(boolean value) {
        if (this.captured == value) {
            return this;
        }
        return new ImmutableChargeResult(this.token, this.success, this.createdAt, this.statusMessage, this.errorMessage, this.card, value, this.authorisationExpired, this.transfer, this.amountRefunded, this.totalFees, this.merchantEntitlement, this.refundPending, this.settlementCurrency, this.email, this.description, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableChargeResult withAuthorisationExpired(boolean value) {
        if (this.authorisationExpired == value) {
            return this;
        }
        return new ImmutableChargeResult(this.token, this.success, this.createdAt, this.statusMessage, this.errorMessage, this.card, this.captured, value, this.transfer, this.amountRefunded, this.totalFees, this.merchantEntitlement, this.refundPending, this.settlementCurrency, this.email, this.description, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableChargeResult withTransfer(Transfer ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableChargeResult(this.token, this.success, this.createdAt, this.statusMessage, this.errorMessage, this.card, this.captured, this.authorisationExpired, (ImmutableList<Transfer>)newValue, this.amountRefunded, this.totalFees, this.merchantEntitlement, this.refundPending, this.settlementCurrency, this.email, this.description, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableChargeResult withTransfer(Iterable<? extends Transfer> elements) {
        if (this.transfer == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableChargeResult(this.token, this.success, this.createdAt, this.statusMessage, this.errorMessage, this.card, this.captured, this.authorisationExpired, (ImmutableList<Transfer>)newValue, this.amountRefunded, this.totalFees, this.merchantEntitlement, this.refundPending, this.settlementCurrency, this.email, this.description, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableChargeResult withAmountRefunded(BigDecimal value) {
        if (this.amountRefunded.equals(value)) {
            return this;
        }
        BigDecimal newValue = (BigDecimal)Preconditions.checkNotNull((Object)value, (Object)"amountRefunded");
        return new ImmutableChargeResult(this.token, this.success, this.createdAt, this.statusMessage, this.errorMessage, this.card, this.captured, this.authorisationExpired, this.transfer, newValue, this.totalFees, this.merchantEntitlement, this.refundPending, this.settlementCurrency, this.email, this.description, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableChargeResult withTotalFees(@Nullable BigDecimal value) {
        if (Objects.equal((Object)this.totalFees, (Object)value)) {
            return this;
        }
        return new ImmutableChargeResult(this.token, this.success, this.createdAt, this.statusMessage, this.errorMessage, this.card, this.captured, this.authorisationExpired, this.transfer, this.amountRefunded, value, this.merchantEntitlement, this.refundPending, this.settlementCurrency, this.email, this.description, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableChargeResult withMerchantEntitlement(@Nullable BigDecimal value) {
        if (Objects.equal((Object)this.merchantEntitlement, (Object)value)) {
            return this;
        }
        return new ImmutableChargeResult(this.token, this.success, this.createdAt, this.statusMessage, this.errorMessage, this.card, this.captured, this.authorisationExpired, this.transfer, this.amountRefunded, this.totalFees, value, this.refundPending, this.settlementCurrency, this.email, this.description, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableChargeResult withRefundPending(boolean value) {
        if (this.refundPending == value) {
            return this;
        }
        return new ImmutableChargeResult(this.token, this.success, this.createdAt, this.statusMessage, this.errorMessage, this.card, this.captured, this.authorisationExpired, this.transfer, this.amountRefunded, this.totalFees, this.merchantEntitlement, value, this.settlementCurrency, this.email, this.description, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableChargeResult withSettlementCurrency(String value) {
        if (this.settlementCurrency.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"settlementCurrency");
        return new ImmutableChargeResult(this.token, this.success, this.createdAt, this.statusMessage, this.errorMessage, this.card, this.captured, this.authorisationExpired, this.transfer, this.amountRefunded, this.totalFees, this.merchantEntitlement, this.refundPending, newValue, this.email, this.description, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableChargeResult withEmail(String value) {
        if (this.email.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"email");
        return new ImmutableChargeResult(this.token, this.success, this.createdAt, this.statusMessage, this.errorMessage, this.card, this.captured, this.authorisationExpired, this.transfer, this.amountRefunded, this.totalFees, this.merchantEntitlement, this.refundPending, this.settlementCurrency, newValue, this.description, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableChargeResult withDescription(String value) {
        if (this.description.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"description");
        return new ImmutableChargeResult(this.token, this.success, this.createdAt, this.statusMessage, this.errorMessage, this.card, this.captured, this.authorisationExpired, this.transfer, this.amountRefunded, this.totalFees, this.merchantEntitlement, this.refundPending, this.settlementCurrency, this.email, newValue, this.amount, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableChargeResult withAmount(Integer value) {
        if (this.amount.equals(value)) {
            return this;
        }
        Integer newValue = (Integer)Preconditions.checkNotNull((Object)value, (Object)"amount");
        return new ImmutableChargeResult(this.token, this.success, this.createdAt, this.statusMessage, this.errorMessage, this.card, this.captured, this.authorisationExpired, this.transfer, this.amountRefunded, this.totalFees, this.merchantEntitlement, this.refundPending, this.settlementCurrency, this.email, this.description, newValue, this.ipAddress, this.currency, this.metadata);
    }

    public final ImmutableChargeResult withIpAddress(String value) {
        if (this.ipAddress.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"ipAddress");
        return new ImmutableChargeResult(this.token, this.success, this.createdAt, this.statusMessage, this.errorMessage, this.card, this.captured, this.authorisationExpired, this.transfer, this.amountRefunded, this.totalFees, this.merchantEntitlement, this.refundPending, this.settlementCurrency, this.email, this.description, this.amount, newValue, this.currency, this.metadata);
    }

    public final ImmutableChargeResult withCurrency(String value) {
        if (this.currency.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"currency");
        return new ImmutableChargeResult(this.token, this.success, this.createdAt, this.statusMessage, this.errorMessage, this.card, this.captured, this.authorisationExpired, this.transfer, this.amountRefunded, this.totalFees, this.merchantEntitlement, this.refundPending, this.settlementCurrency, this.email, this.description, this.amount, this.ipAddress, newValue, this.metadata);
    }

    public final ImmutableChargeResult withMetadata(Map<String, ? extends String> entries) {
        if (this.metadata == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableChargeResult(this.token, this.success, this.createdAt, this.statusMessage, this.errorMessage, this.card, this.captured, this.authorisationExpired, this.transfer, this.amountRefunded, this.totalFees, this.merchantEntitlement, this.refundPending, this.settlementCurrency, this.email, this.description, this.amount, this.ipAddress, this.currency, (ImmutableMap<String, String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChargeResult && this.equalTo((ImmutableChargeResult)another);
    }

    private boolean equalTo(ImmutableChargeResult another) {
        return this.token.equals(another.token) && this.success == another.success && this.createdAt.equals(another.createdAt) && this.statusMessage.equals(another.statusMessage) && Objects.equal((Object)this.errorMessage, (Object)another.errorMessage) && this.card.equals(another.card) && this.captured == another.captured && this.authorisationExpired == another.authorisationExpired && this.transfer.equals(another.transfer) && this.amountRefunded.equals(another.amountRefunded) && Objects.equal((Object)this.totalFees, (Object)another.totalFees) && Objects.equal((Object)this.merchantEntitlement, (Object)another.merchantEntitlement) && this.refundPending == another.refundPending && this.settlementCurrency.equals(another.settlementCurrency) && this.email.equals(another.email) && this.description.equals(another.description) && this.amount.equals(another.amount) && this.ipAddress.equals(another.ipAddress) && this.currency.equals(another.currency) && this.metadata.equals(another.metadata);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.success);
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.statusMessage.hashCode();
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.errorMessage});
        h += (h << 5) + this.card.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.captured);
        h += (h << 5) + Booleans.hashCode((boolean)this.authorisationExpired);
        h += (h << 5) + this.transfer.hashCode();
        h += (h << 5) + this.amountRefunded.hashCode();
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.totalFees});
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.merchantEntitlement});
        h += (h << 5) + Booleans.hashCode((boolean)this.refundPending);
        h += (h << 5) + this.settlementCurrency.hashCode();
        h += (h << 5) + this.email.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.amount.hashCode();
        h += (h << 5) + this.ipAddress.hashCode();
        h += (h << 5) + this.currency.hashCode();
        h += (h << 5) + this.metadata.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ChargeResult").omitNullValues().add("token", (Object)this.token).add("success", this.success).add("createdAt", (Object)this.createdAt).add("statusMessage", (Object)this.statusMessage).add("errorMessage", (Object)this.errorMessage).add("card", (Object)this.card).add("captured", this.captured).add("authorisationExpired", this.authorisationExpired).add("transfer", this.transfer).add("amountRefunded", (Object)this.amountRefunded).add("totalFees", (Object)this.totalFees).add("merchantEntitlement", (Object)this.merchantEntitlement).add("refundPending", this.refundPending).add("settlementCurrency", (Object)this.settlementCurrency).add("email", (Object)this.email).add("description", (Object)this.description).add("amount", (Object)this.amount).add("ipAddress", (Object)this.ipAddress).add("currency", (Object)this.currency).add("metadata", this.metadata).toString();
    }

    public static ImmutableChargeResult copyOf(ChargeResult instance) {
        if (instance instanceof ImmutableChargeResult) {
            return (ImmutableChargeResult)instance;
        }
        return ImmutableChargeResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOKEN = 1L;
        private static final long INIT_BIT_SUCCESS = 2L;
        private static final long INIT_BIT_CREATED_AT = 4L;
        private static final long INIT_BIT_STATUS_MESSAGE = 8L;
        private static final long INIT_BIT_CARD = 16L;
        private static final long INIT_BIT_CAPTURED = 32L;
        private static final long INIT_BIT_AUTHORISATION_EXPIRED = 64L;
        private static final long INIT_BIT_AMOUNT_REFUNDED = 128L;
        private static final long INIT_BIT_REFUND_PENDING = 256L;
        private static final long INIT_BIT_SETTLEMENT_CURRENCY = 512L;
        private static final long INIT_BIT_EMAIL = 1024L;
        private static final long INIT_BIT_DESCRIPTION = 2048L;
        private static final long INIT_BIT_AMOUNT = 4096L;
        private static final long INIT_BIT_IP_ADDRESS = 8192L;
        private static final long INIT_BIT_CURRENCY = 16384L;
        private long initBits = 32767L;
        @Nullable
        private String token;
        private boolean success;
        @Nullable
        private String createdAt;
        @Nullable
        private String statusMessage;
        @Nullable
        private String errorMessage;
        @Nullable
        private CardResult card;
        private boolean captured;
        private boolean authorisationExpired;
        private ImmutableList.Builder<Transfer> transfer = ImmutableList.builder();
        @Nullable
        private BigDecimal amountRefunded;
        @Nullable
        private BigDecimal totalFees;
        @Nullable
        private BigDecimal merchantEntitlement;
        private boolean refundPending;
        @Nullable
        private String settlementCurrency;
        @Nullable
        private String email;
        @Nullable
        private String description;
        @Nullable
        private Integer amount;
        @Nullable
        private String ipAddress;
        @Nullable
        private String currency;
        private ImmutableMap.Builder<String, String> metadata = ImmutableMap.builder();

        private Builder() {
        }

        public final Builder from(ChargeBase instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChargeResult instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChargeBase instance;
            if (object instanceof ChargeBase) {
                instance = (ChargeBase)object;
                this.ipAddress(instance.ipAddress());
                this.description(instance.description());
                this.amount(instance.amount());
                this.putAllMetadata(instance.metadata());
                this.currency(instance.currency());
                this.email(instance.email());
            }
            if (object instanceof ChargeResult) {
                instance = (ChargeResult)object;
                BigDecimal totalFeesValue = instance.totalFees();
                if (totalFeesValue != null) {
                    this.totalFees(totalFeesValue);
                }
                this.authorisationExpired(instance.authorisationExpired());
                String errorMessageValue = instance.errorMessage();
                if (errorMessageValue != null) {
                    this.errorMessage(errorMessageValue);
                }
                this.statusMessage(instance.statusMessage());
                this.token(instance.token());
                this.createdAt(instance.createdAt());
                this.addAllTransfer(instance.transfer());
                this.settlementCurrency(instance.settlementCurrency());
                BigDecimal merchantEntitlementValue = instance.merchantEntitlement();
                if (merchantEntitlementValue != null) {
                    this.merchantEntitlement(merchantEntitlementValue);
                }
                this.success(instance.success());
                this.captured(instance.captured());
                this.amountRefunded(instance.amountRefunded());
                this.refundPending(instance.refundPending());
                this.card(instance.card());
            }
        }

        public final Builder token(String token) {
            this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder success(boolean success) {
            this.success = success;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder createdAt(String createdAt) {
            this.createdAt = (String)Preconditions.checkNotNull((Object)createdAt, (Object)"createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = (String)Preconditions.checkNotNull((Object)statusMessage, (Object)"statusMessage");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder errorMessage(@Nullable String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Builder card(CardResult card) {
            this.card = (CardResult)Preconditions.checkNotNull((Object)card, (Object)"card");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder captured(boolean captured) {
            this.captured = captured;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder authorisationExpired(boolean authorisationExpired) {
            this.authorisationExpired = authorisationExpired;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder addTransfer(Transfer element) {
            this.transfer.add((Object)element);
            return this;
        }

        public final Builder addTransfer(Transfer ... elements) {
            this.transfer.add((Object[])elements);
            return this;
        }

        public final Builder transfer(Iterable<? extends Transfer> elements) {
            this.transfer = ImmutableList.builder();
            return this.addAllTransfer(elements);
        }

        public final Builder addAllTransfer(Iterable<? extends Transfer> elements) {
            this.transfer.addAll(elements);
            return this;
        }

        public final Builder amountRefunded(BigDecimal amountRefunded) {
            this.amountRefunded = (BigDecimal)Preconditions.checkNotNull((Object)amountRefunded, (Object)"amountRefunded");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder totalFees(@Nullable BigDecimal totalFees) {
            this.totalFees = totalFees;
            return this;
        }

        public final Builder merchantEntitlement(@Nullable BigDecimal merchantEntitlement) {
            this.merchantEntitlement = merchantEntitlement;
            return this;
        }

        public final Builder refundPending(boolean refundPending) {
            this.refundPending = refundPending;
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder settlementCurrency(String settlementCurrency) {
            this.settlementCurrency = (String)Preconditions.checkNotNull((Object)settlementCurrency, (Object)"settlementCurrency");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public final Builder email(String email) {
            this.email = (String)Preconditions.checkNotNull((Object)email, (Object)"email");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        public final Builder description(String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        public final Builder amount(Integer amount) {
            this.amount = (Integer)Preconditions.checkNotNull((Object)amount, (Object)"amount");
            this.initBits &= 0xFFFFFFFFFFFFEFFFL;
            return this;
        }

        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = (String)Preconditions.checkNotNull((Object)ipAddress, (Object)"ipAddress");
            this.initBits &= 0xFFFFFFFFFFFFDFFFL;
            return this;
        }

        public final Builder currency(String currency) {
            this.currency = (String)Preconditions.checkNotNull((Object)currency, (Object)"currency");
            this.initBits &= 0xFFFFFFFFFFFFBFFFL;
            return this;
        }

        public final Builder putMetadata(String key, String value) {
            this.metadata.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putMetadata(Map.Entry<String, ? extends String> entry) {
            this.metadata.put(entry);
            return this;
        }

        public final Builder metadata(Map<String, ? extends String> metadata) {
            this.metadata = ImmutableMap.builder();
            return this.putAllMetadata(metadata);
        }

        public final Builder putAllMetadata(Map<String, ? extends String> metadata) {
            this.metadata.putAll(metadata);
            return this;
        }

        public ImmutableChargeResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChargeResult(this.token, this.success, this.createdAt, this.statusMessage, this.errorMessage, this.card, this.captured, this.authorisationExpired, this.transfer.build(), this.amountRefunded, this.totalFees, this.merchantEntitlement, this.refundPending, this.settlementCurrency, this.email, this.description, this.amount, this.ipAddress, this.currency, this.metadata.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("token");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("success");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("statusMessage");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("card");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("captured");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("authorisationExpired");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("amountRefunded");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("refundPending");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("settlementCurrency");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("email");
            }
            if ((this.initBits & 0x800L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 0x1000L) != 0L) {
                attributes.add("amount");
            }
            if ((this.initBits & 0x2000L) != 0L) {
                attributes.add("ipAddress");
            }
            if ((this.initBits & 0x4000L) != 0L) {
                attributes.add("currency");
            }
            return "Cannot build ChargeResult, some of required attributes are not set " + attributes;
        }
    }
}

