/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.CustomerResponse;
import org.wisepersist.pinpayments.pojo.CustomerResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableCustomerResponse
implements CustomerResponse {
    private final CustomerResult response;

    private ImmutableCustomerResponse(CustomerResult response) {
        this.response = response;
    }

    @Override
    public CustomerResult response() {
        return this.response;
    }

    public final ImmutableCustomerResponse withResponse(CustomerResult value) {
        if (this.response == value) {
            return this;
        }
        CustomerResult newValue = (CustomerResult)Preconditions.checkNotNull((Object)value, (Object)"response");
        return new ImmutableCustomerResponse(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCustomerResponse && this.equalTo((ImmutableCustomerResponse)another);
    }

    private boolean equalTo(ImmutableCustomerResponse another) {
        return this.response.equals(another.response);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.response.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CustomerResponse").omitNullValues().add("response", (Object)this.response).toString();
    }

    public static ImmutableCustomerResponse copyOf(CustomerResponse instance) {
        if (instance instanceof ImmutableCustomerResponse) {
            return (ImmutableCustomerResponse)instance;
        }
        return ImmutableCustomerResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RESPONSE = 1L;
        private long initBits = 1L;
        @Nullable
        private CustomerResult response;

        private Builder() {
        }

        public final Builder from(CustomerResponse instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.response(instance.response());
            return this;
        }

        public final Builder response(CustomerResult response) {
            this.response = (CustomerResult)Preconditions.checkNotNull((Object)response, (Object)"response");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableCustomerResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCustomerResponse(this.response);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("response");
            }
            return "Cannot build CustomerResponse, some of required attributes are not set " + attributes;
        }
    }
}

