/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.CardResult;
import org.wisepersist.pinpayments.pojo.CustomerBase;
import org.wisepersist.pinpayments.pojo.CustomerResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableCustomerResult
implements CustomerResult {
    private final String token;
    private final String createdAt;
    private final CardResult card;
    private final String email;

    private ImmutableCustomerResult(String token, String createdAt, CardResult card, String email) {
        this.token = token;
        this.createdAt = createdAt;
        this.card = card;
        this.email = email;
    }

    @Override
    public String token() {
        return this.token;
    }

    @Override
    public String createdAt() {
        return this.createdAt;
    }

    @Override
    public CardResult card() {
        return this.card;
    }

    @Override
    public String email() {
        return this.email;
    }

    public final ImmutableCustomerResult withToken(String value) {
        if (this.token.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"token");
        return new ImmutableCustomerResult(newValue, this.createdAt, this.card, this.email);
    }

    public final ImmutableCustomerResult withCreatedAt(String value) {
        if (this.createdAt.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"createdAt");
        return new ImmutableCustomerResult(this.token, newValue, this.card, this.email);
    }

    public final ImmutableCustomerResult withCard(CardResult value) {
        if (this.card == value) {
            return this;
        }
        CardResult newValue = (CardResult)Preconditions.checkNotNull((Object)value, (Object)"card");
        return new ImmutableCustomerResult(this.token, this.createdAt, newValue, this.email);
    }

    public final ImmutableCustomerResult withEmail(String value) {
        if (this.email.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"email");
        return new ImmutableCustomerResult(this.token, this.createdAt, this.card, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCustomerResult && this.equalTo((ImmutableCustomerResult)another);
    }

    private boolean equalTo(ImmutableCustomerResult another) {
        return this.token.equals(another.token) && this.createdAt.equals(another.createdAt) && this.card.equals(another.card) && this.email.equals(another.email);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.card.hashCode();
        h += (h << 5) + this.email.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CustomerResult").omitNullValues().add("token", (Object)this.token).add("createdAt", (Object)this.createdAt).add("card", (Object)this.card).add("email", (Object)this.email).toString();
    }

    public static ImmutableCustomerResult copyOf(CustomerResult instance) {
        if (instance instanceof ImmutableCustomerResult) {
            return (ImmutableCustomerResult)instance;
        }
        return ImmutableCustomerResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOKEN = 1L;
        private static final long INIT_BIT_CREATED_AT = 2L;
        private static final long INIT_BIT_CARD = 4L;
        private static final long INIT_BIT_EMAIL = 8L;
        private long initBits = 15L;
        @Nullable
        private String token;
        @Nullable
        private String createdAt;
        @Nullable
        private CardResult card;
        @Nullable
        private String email;

        private Builder() {
        }

        public final Builder from(CustomerBase instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(CustomerResult instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            CustomerBase instance;
            if (object instanceof CustomerBase) {
                instance = (CustomerBase)object;
                this.email(instance.email());
            }
            if (object instanceof CustomerResult) {
                instance = (CustomerResult)object;
                this.createdAt(instance.createdAt());
                this.card(instance.card());
                this.token(instance.token());
            }
        }

        public final Builder token(String token) {
            this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder createdAt(String createdAt) {
            this.createdAt = (String)Preconditions.checkNotNull((Object)createdAt, (Object)"createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder card(CardResult card) {
            this.card = (CardResult)Preconditions.checkNotNull((Object)card, (Object)"card");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder email(String email) {
            this.email = (String)Preconditions.checkNotNull((Object)email, (Object)"email");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableCustomerResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCustomerResult(this.token, this.createdAt, this.card, this.email);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("token");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("card");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("email");
            }
            return "Cannot build CustomerResult, some of required attributes are not set " + attributes;
        }
    }
}

