/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.DeletionResult;
import org.wisepersist.pinpayments.pojo.ErrorResponse;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableDeletionResult
implements DeletionResult {
    private final boolean success;
    @Nullable
    private final ErrorResponse errorResponse;

    private ImmutableDeletionResult(boolean success, @Nullable ErrorResponse errorResponse) {
        this.success = success;
        this.errorResponse = errorResponse;
    }

    @Override
    public boolean success() {
        return this.success;
    }

    @Override
    @Nullable
    public ErrorResponse errorResponse() {
        return this.errorResponse;
    }

    public final ImmutableDeletionResult withSuccess(boolean value) {
        if (this.success == value) {
            return this;
        }
        return new ImmutableDeletionResult(value, this.errorResponse);
    }

    public final ImmutableDeletionResult withErrorResponse(@Nullable ErrorResponse value) {
        if (this.errorResponse == value) {
            return this;
        }
        return new ImmutableDeletionResult(this.success, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeletionResult && this.equalTo((ImmutableDeletionResult)another);
    }

    private boolean equalTo(ImmutableDeletionResult another) {
        return this.success == another.success && Objects.equal((Object)this.errorResponse, (Object)another.errorResponse);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.success);
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.errorResponse});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DeletionResult").omitNullValues().add("success", this.success).add("errorResponse", (Object)this.errorResponse).toString();
    }

    public static ImmutableDeletionResult copyOf(DeletionResult instance) {
        if (instance instanceof ImmutableDeletionResult) {
            return (ImmutableDeletionResult)instance;
        }
        return ImmutableDeletionResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SUCCESS = 1L;
        private long initBits = 1L;
        private boolean success;
        @Nullable
        private ErrorResponse errorResponse;

        private Builder() {
        }

        public final Builder from(DeletionResult instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.success(instance.success());
            ErrorResponse errorResponseValue = instance.errorResponse();
            if (errorResponseValue != null) {
                this.errorResponse(errorResponseValue);
            }
            return this;
        }

        public final Builder success(boolean success) {
            this.success = success;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder errorResponse(@Nullable ErrorResponse errorResponse) {
            this.errorResponse = errorResponse;
            return this;
        }

        public ImmutableDeletionResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeletionResult(this.success, this.errorResponse);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("success");
            }
            return "Cannot build DeletionResult, some of required attributes are not set " + attributes;
        }
    }
}

