/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.EventResponse;
import org.wisepersist.pinpayments.pojo.EventResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableEventResponse
implements EventResponse {
    private final EventResult response;

    private ImmutableEventResponse(EventResult response) {
        this.response = response;
    }

    @Override
    public EventResult response() {
        return this.response;
    }

    public final ImmutableEventResponse withResponse(EventResult value) {
        if (this.response == value) {
            return this;
        }
        EventResult newValue = (EventResult)Preconditions.checkNotNull((Object)value, (Object)"response");
        return new ImmutableEventResponse(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEventResponse && this.equalTo((ImmutableEventResponse)another);
    }

    private boolean equalTo(ImmutableEventResponse another) {
        return this.response.equals(another.response);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.response.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EventResponse").omitNullValues().add("response", (Object)this.response).toString();
    }

    public static ImmutableEventResponse copyOf(EventResponse instance) {
        if (instance instanceof ImmutableEventResponse) {
            return (ImmutableEventResponse)instance;
        }
        return ImmutableEventResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RESPONSE = 1L;
        private long initBits = 1L;
        @Nullable
        private EventResult response;

        private Builder() {
        }

        public final Builder from(EventResponse instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.response(instance.response());
            return this;
        }

        public final Builder response(EventResult response) {
            this.response = (EventResult)Preconditions.checkNotNull((Object)response, (Object)"response");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableEventResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEventResponse(this.response);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("response");
            }
            return "Cannot build EventResponse, some of required attributes are not set " + attributes;
        }
    }
}

