/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.RecipientResponse;
import org.wisepersist.pinpayments.pojo.RecipientResult;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableRecipientResponse
implements RecipientResponse {
    private final RecipientResult response;

    private ImmutableRecipientResponse(RecipientResult response) {
        this.response = response;
    }

    @Override
    public RecipientResult response() {
        return this.response;
    }

    public final ImmutableRecipientResponse withResponse(RecipientResult value) {
        if (this.response == value) {
            return this;
        }
        RecipientResult newValue = (RecipientResult)Preconditions.checkNotNull((Object)value, (Object)"response");
        return new ImmutableRecipientResponse(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRecipientResponse && this.equalTo((ImmutableRecipientResponse)another);
    }

    private boolean equalTo(ImmutableRecipientResponse another) {
        return this.response.equals(another.response);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.response.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RecipientResponse").omitNullValues().add("response", (Object)this.response).toString();
    }

    public static ImmutableRecipientResponse copyOf(RecipientResponse instance) {
        if (instance instanceof ImmutableRecipientResponse) {
            return (ImmutableRecipientResponse)instance;
        }
        return ImmutableRecipientResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RESPONSE = 1L;
        private long initBits = 1L;
        @Nullable
        private RecipientResult response;

        private Builder() {
        }

        public final Builder from(RecipientResponse instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.response(instance.response());
            return this;
        }

        public final Builder response(RecipientResult response) {
            this.response = (RecipientResult)Preconditions.checkNotNull((Object)response, (Object)"response");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableRecipientResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRecipientResponse(this.response);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("response");
            }
            return "Cannot build RecipientResponse, some of required attributes are not set " + attributes;
        }
    }
}

