/*
 * Decompiled with CFR 0.152.
 */
package org.wisepersist.pinpayments.pojo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.wisepersist.pinpayments.pojo.Refund;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableRefund
implements Refund {
    @Nullable
    private final Integer amount;

    private ImmutableRefund(@Nullable Integer amount) {
        this.amount = amount;
    }

    @Override
    @Nullable
    public Integer amount() {
        return this.amount;
    }

    public final ImmutableRefund withAmount(@Nullable Integer value) {
        if (Objects.equal((Object)this.amount, (Object)value)) {
            return this;
        }
        return new ImmutableRefund(value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRefund && this.equalTo((ImmutableRefund)another);
    }

    private boolean equalTo(ImmutableRefund another) {
        return Objects.equal((Object)this.amount, (Object)another.amount);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object[])new Object[]{this.amount});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Refund").omitNullValues().add("amount", (Object)this.amount).toString();
    }

    public static ImmutableRefund copyOf(Refund instance) {
        if (instance instanceof ImmutableRefund) {
            return (ImmutableRefund)instance;
        }
        return ImmutableRefund.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Integer amount;

        private Builder() {
        }

        public final Builder from(Refund instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Integer amountValue = instance.amount();
            if (amountValue != null) {
                this.amount(amountValue);
            }
            return this;
        }

        public final Builder amount(@Nullable Integer amount) {
            this.amount = amount;
            return this;
        }

        public ImmutableRefund build() {
            return new ImmutableRefund(this.amount);
        }
    }
}

